/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import java.util.Objects;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.segment.column.ColumnType;

public class RangeRefKey {
    private final String column;
    private final ColumnType matchValueType;

    public RangeRefKey(String column, ColumnType matchValueType) {
        this.column = column;
        this.matchValueType = matchValueType;
    }

    public static RangeRefKey from(RangeFilter filter) {
        return new RangeRefKey(filter.getColumn(), filter.getMatchValueType());
    }

    public static RangeRefKey from(EqualityFilter filter) {
        return new RangeRefKey(filter.getColumn(), filter.getMatchValueType());
    }

    public String getColumn() {
        return this.column;
    }

    public ColumnType getMatchValueType() {
        return this.matchValueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeRefKey that = (RangeRefKey)o;
        return Objects.equals(this.column, that.column) && Objects.equals(this.matchValueType, that.matchValueType);
    }

    public int hashCode() {
        return Objects.hash(this.column, this.matchValueType);
    }

    public String toString() {
        return "RangeRefKey{column='" + this.column + "', matchValueType=" + String.valueOf(this.matchValueType) + "}";
    }
}

