/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.filter.ArrayContainsElementFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.builtin.BaseExpressionDimFilterOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ScalarInArrayOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ArrayOverlapOperatorConversion
extends BaseExpressionDimFilterOperatorConversion {
    private static final String EXPR_FUNCTION = "array_overlap";
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("ARRAY_OVERLAP").operandTypeChecker(OperandTypes.sequence((String)"'ARRAY_OVERLAP(array, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})})).returnTypeInference(ReturnTypes.BOOLEAN_NULLABLE).build();

    public ArrayOverlapOperatorConversion() {
        this((SqlOperator)SQL_FUNCTION, EXPR_FUNCTION);
    }

    protected ArrayOverlapOperatorConversion(SqlOperator operator, String druidFunctionName) {
        super(operator, druidFunctionName);
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        DruidExpression complexExpr;
        DruidExpression simpleExtractionExpr;
        boolean rightSimpleExtractionExpr;
        List operands = ((RexCall)rexNode).getOperands();
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, operands);
        if (druidExpressions == null) {
            return null;
        }
        DruidExpression leftExpr = druidExpressions.get(0);
        DruidExpression rightExpr = druidExpressions.get(1);
        boolean leftSimpleExtractionExpr = leftExpr.isSimpleExtraction();
        if (leftSimpleExtractionExpr ^ (rightSimpleExtractionExpr = rightExpr.isSimpleExtraction())) {
            if (leftSimpleExtractionExpr) {
                simpleExtractionExpr = leftExpr;
                complexExpr = rightExpr;
            } else {
                simpleExtractionExpr = rightExpr;
                complexExpr = leftExpr;
            }
        } else {
            return this.toExpressionFilter(plannerContext, druidExpressions);
        }
        Expr expr = plannerContext.parseExpression(complexExpr.getExpression());
        if (expr.isLiteral() && !simpleExtractionExpr.isArray()) {
            ExprEval exprEval = expr.eval(InputBindings.nilBindings());
            Object[] arrayElements = exprEval.asArray();
            if (arrayElements == null || arrayElements.length == 0) {
                return null;
            }
            if (arrayElements.length == 1) {
                String column;
                if (plannerContext.isUseBoundsAndSelectors()) {
                    return ArrayOverlapOperatorConversion.newSelectorDimFilter(simpleExtractionExpr.getSimpleExtraction(), Evals.asString((Object)arrayElements[0]));
                }
                if (simpleExtractionExpr.isDirectColumnAccess()) {
                    column = simpleExtractionExpr.getDirectColumn();
                } else {
                    if (virtualColumnRegistry == null) {
                        return this.toExpressionFilter(plannerContext, druidExpressions);
                    }
                    column = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(simpleExtractionExpr, simpleExtractionExpr.getDruidType());
                }
                Object elementValue = arrayElements[0];
                if (elementValue == null) {
                    return NullFilter.forColumn((String)column);
                }
                return new EqualityFilter(column, ExpressionType.toColumnType((ExpressionType)exprEval.type()), elementValue, null);
            }
            return ScalarInArrayOperatorConversion.makeInFilter(plannerContext, simpleExtractionExpr.getSimpleExtraction().getColumn(), simpleExtractionExpr.getSimpleExtraction().getExtractionFn(), Arrays.asList(arrayElements), ExpressionType.toColumnType((ExpressionType)((ExpressionType)exprEval.type().getElementType())));
        }
        if (simpleExtractionExpr.isDirectColumnAccess() && simpleExtractionExpr.isArray() && expr.isLiteral()) {
            ExprEval exprEval = expr.eval(InputBindings.nilBindings());
            if (exprEval.isArray()) {
                Object[] arrayElements = exprEval.asArray();
                if (arrayElements.length == 0) {
                    return null;
                }
                ArrayList<ArrayContainsElementFilter> filters = new ArrayList<ArrayContainsElementFilter>(arrayElements.length);
                ColumnType elementType = ExpressionType.toColumnType((ExpressionType)ExpressionType.elementType((ExpressionType)exprEval.type()));
                for (Object val : arrayElements) {
                    filters.add(new ArrayContainsElementFilter(leftExpr.getSimpleExtraction().getColumn(), elementType, val, null));
                }
                return filters.size() == 1 ? (DimFilter)filters.get(0) : new OrDimFilter(filters);
            }
            return new ArrayContainsElementFilter(leftExpr.getSimpleExtraction().getColumn(), ExpressionType.toColumnType((ExpressionType)exprEval.type()), exprEval.valueOrDefault(), null);
        }
        return this.toExpressionFilter(plannerContext, druidExpressions);
    }
}

