/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Static;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.expression.OperatorConversions;

public class DefaultOperandTypeChecker
implements SqlOperandTypeChecker {
    private final List<String> operandNames;
    private final List<SqlTypeFamily> operandTypes;
    private final int requiredOperands;
    private final IntSet nullableOperands;
    private final IntSet literalOperands;

    private DefaultOperandTypeChecker(List<String> operandNames, List<SqlTypeFamily> operandTypes, int requiredOperands, IntSet nullableOperands, @Nullable int[] literalOperands) {
        Preconditions.checkArgument((requiredOperands <= operandTypes.size() && requiredOperands >= 0 ? 1 : 0) != 0);
        this.operandNames = (List)Preconditions.checkNotNull(operandNames, (Object)"operandNames");
        this.operandTypes = (List)Preconditions.checkNotNull(operandTypes, (Object)"operandTypes");
        this.requiredOperands = requiredOperands;
        this.nullableOperands = (IntSet)Preconditions.checkNotNull((Object)nullableOperands, (Object)"nullableOperands");
        if (!operandNames.isEmpty() && operandNames.size() != operandTypes.size()) {
            throw new ISE("Operand name count[%s] and type count[%s] must match", new Object[]{operandNames.size(), operandTypes.size()});
        }
        if (literalOperands == null) {
            this.literalOperands = IntSets.EMPTY_SET;
        } else {
            this.literalOperands = new IntArraySet();
            Arrays.stream(literalOperands).forEach(arg_0 -> ((IntSet)this.literalOperands).add(arg_0));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        for (int i = 0; i < callBinding.operands().size(); ++i) {
            SqlNode operand = (SqlNode)callBinding.operands().get(i);
            if (this.literalOperands.contains(i) && !SqlUtil.isLiteral((SqlNode)operand, (boolean)true)) {
                return OperatorConversions.throwOrReturn(throwOnFailure, callBinding, cb -> cb.getValidator().newValidationError(operand, Static.RESOURCE.argumentMustBeLiteral(callBinding.getOperator().getName())));
            }
            RelDataType operandType = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
            SqlTypeFamily expectedFamily = this.operandTypes.get(i);
            if (expectedFamily == SqlTypeFamily.ANY || expectedFamily.getTypeNames().contains(operandType.getSqlTypeName())) continue;
            if (operandType.getSqlTypeName() == SqlTypeName.NULL || SqlUtil.isNullLiteral((SqlNode)operand, (boolean)true)) {
                if (this.nullableOperands.contains(i)) continue;
                return OperatorConversions.throwOrReturn(throwOnFailure, callBinding, cb -> cb.getValidator().newValidationError(operand, Static.RESOURCE.nullIllegal()));
            }
            return OperatorConversions.throwOrReturn(throwOnFailure, callBinding, SqlCallBinding::newValidationSignatureError);
        }
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between((int)this.requiredOperands, (int)this.operandTypes.size());
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        int i;
        List<String> operands = !this.operandNames.isEmpty() ? this.operandNames : this.operandTypes;
        StringBuilder ret = new StringBuilder();
        ret.append("'");
        ret.append(opName);
        ret.append("(");
        for (i = 0; i < operands.size(); ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            if (i >= this.requiredOperands) {
                ret.append("[");
            }
            ret.append("<").append((Object)operands.get(i)).append(">");
        }
        for (i = this.requiredOperands; i < operands.size(); ++i) {
            ret.append("]");
        }
        ret.append(")'");
        return ret.toString();
    }

    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    public boolean isOptional(int i) {
        return i + 1 > this.requiredOperands;
    }

    public static IntSet buildNullableOperands(int requiredOperandCount, int totalOperandCount, IntSet notNullOperands) {
        IntArraySet nullableOperands = new IntArraySet();
        IntStream.range(requiredOperandCount, totalOperandCount).filter(i -> !notNullOperands.contains(i)).forEach(arg_0 -> ((IntSet)nullableOperands).add(arg_0));
        return nullableOperands;
    }

    public static class Builder {
        private List<String> operandNames = Collections.emptyList();
        private List<SqlTypeFamily> operandTypes;
        @Nullable
        private Integer requiredOperandCount;
        private int[] literalOperands;
        private IntSet notNullOperands = new IntArraySet();

        private Builder() {
        }

        public Builder operandNames(String ... operandNames) {
            this.operandNames = Arrays.asList(operandNames);
            return this;
        }

        public Builder operandNames(List<String> operandNames) {
            this.operandNames = operandNames;
            return this;
        }

        public Builder operandTypes(SqlTypeFamily ... operandTypes) {
            this.operandTypes = Arrays.asList(operandTypes);
            return this;
        }

        public Builder operandTypes(List<SqlTypeFamily> operandTypes) {
            this.operandTypes = operandTypes;
            return this;
        }

        public Builder requiredOperandCount(Integer requiredOperandCount) {
            this.requiredOperandCount = requiredOperandCount;
            return this;
        }

        public Builder literalOperands(int ... literalOperands) {
            this.literalOperands = literalOperands;
            return this;
        }

        public Builder notNullOperands(int ... notNullOperands) {
            Arrays.stream(notNullOperands).forEach(arg_0 -> ((IntSet)this.notNullOperands).add(arg_0));
            return this;
        }

        public DefaultOperandTypeChecker build() {
            int computedRequiredOperandCount = this.requiredOperandCount == null ? this.operandTypes.size() : this.requiredOperandCount.intValue();
            return new DefaultOperandTypeChecker(this.operandNames, this.operandTypes, computedRequiredOperandCount, DefaultOperandTypeChecker.buildNullableOperands(computedRequiredOperandCount, this.operandTypes.size(), this.notNullOperands), this.literalOperands);
        }
    }
}

