/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import io.timeandspace.cronscheduler.CronScheduler;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.DruidBinders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.BasicMonitorScheduler;
import org.apache.druid.java.util.metrics.ClockDriftSafeMonitorScheduler;
import org.apache.druid.java.util.metrics.DruidMonitorSchedulerConfig;
import org.apache.druid.java.util.metrics.JvmCpuMonitor;
import org.apache.druid.java.util.metrics.JvmMonitor;
import org.apache.druid.java.util.metrics.JvmThreadsMonitor;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.java.util.metrics.NoopOshiSysMonitor;
import org.apache.druid.java.util.metrics.NoopSysMonitor;
import org.apache.druid.java.util.metrics.OshiSysMonitor;
import org.apache.druid.java.util.metrics.OshiSysMonitorConfig;
import org.apache.druid.java.util.metrics.SysMonitor;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.server.metrics.MonitorsConfig;

public class MetricsModule
implements Module {
    public static final String MONITORING_PROPERTY_PREFIX = "druid.monitoring";
    private static final Logger log = new Logger(MetricsModule.class);

    public static void register(Binder binder, Class<? extends Monitor> monitorClazz) {
        DruidBinders.metricMonitorBinder(binder).addBinding().toInstance(monitorClazz);
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)MONITORING_PROPERTY_PREFIX, DruidMonitorSchedulerConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)MONITORING_PROPERTY_PREFIX, MonitorsConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.monitoring.sys", OshiSysMonitorConfig.class);
        DruidBinders.metricMonitorBinder(binder);
        binder.bind(ExecutorServiceMonitor.class).in(LazySingleton.class);
        binder.bind(Key.get(MonitorScheduler.class, (Annotation)Names.named((String)"ForTheEagerness"))).to(MonitorScheduler.class).asEagerSingleton();
    }

    @Provides
    @ManageLifecycle
    public MonitorScheduler getMonitorScheduler(Supplier<DruidMonitorSchedulerConfig> config, MonitorsConfig monitorsConfig, Set<Class<? extends Monitor>> monitorSet, @Self Set<NodeRole> nodeRoles, ServiceEmitter emitter, Injector injector) {
        ArrayList<Monitor> monitors = new ArrayList<Monitor>();
        for (Class monitorClass : Iterables.concat(monitorsConfig.getMonitors(), monitorSet)) {
            if (!this.shouldLoadMonitor(monitorClass, nodeRoles)) continue;
            monitors.add((Monitor)injector.getInstance(monitorClass));
        }
        if (!monitors.isEmpty()) {
            log.info("Loaded [%d] monitors: %s", new Object[]{monitors.size(), monitors.stream().map(monitor -> monitor.getClass().getName()).collect(Collectors.joining(", "))});
        }
        if (ClockDriftSafeMonitorScheduler.class.getName().equals(((DruidMonitorSchedulerConfig)config.get()).getSchedulerClassName())) {
            return new ClockDriftSafeMonitorScheduler((DruidMonitorSchedulerConfig)config.get(), emitter, monitors, CronScheduler.newBuilder((Duration)Duration.ofSeconds(1L)).setThreadName("MonitorScheduler").build(), Execs.singleThreaded((String)"MonitorRunner"));
        }
        if (BasicMonitorScheduler.class.getName().equals(((DruidMonitorSchedulerConfig)config.get()).getSchedulerClassName())) {
            return new BasicMonitorScheduler((DruidMonitorSchedulerConfig)config.get(), emitter, monitors, Execs.scheduledSingleThreaded((String)"MonitorScheduler-%s"));
        }
        throw new IAE("Unknown monitor scheduler[%s]", new Object[]{((DruidMonitorSchedulerConfig)config.get()).getSchedulerClassName()});
    }

    @Provides
    @ManageLifecycle
    public JvmMonitor getJvmMonitor() {
        return new JvmMonitor();
    }

    @Provides
    @ManageLifecycle
    public JvmCpuMonitor getJvmCpuMonitor() {
        return new JvmCpuMonitor();
    }

    @Provides
    @ManageLifecycle
    public JvmThreadsMonitor getJvmThreadsMonitor() {
        return new JvmThreadsMonitor();
    }

    @Provides
    @ManageLifecycle
    public SysMonitor getSysMonitor(@Self Set<NodeRole> nodeRoles) {
        if (nodeRoles.contains(NodeRole.PEON)) {
            return new NoopSysMonitor();
        }
        return new SysMonitor();
    }

    @Provides
    @ManageLifecycle
    public OshiSysMonitor getOshiSysMonitor(@Self Set<NodeRole> nodeRoles, OshiSysMonitorConfig oshiSysConfig) {
        if (nodeRoles.contains(NodeRole.PEON)) {
            return new NoopOshiSysMonitor();
        }
        return new OshiSysMonitor(oshiSysConfig);
    }

    private boolean shouldLoadMonitor(Class<?> monitorClass, Set<NodeRole> nodeRoles) {
        LoadScope loadScope = monitorClass.getAnnotation(LoadScope.class);
        if (loadScope == null) {
            Class<?> superClass = monitorClass.getSuperclass();
            return superClass == null || this.shouldLoadMonitor(superClass, nodeRoles);
        }
        for (String role : loadScope.roles()) {
            if (!nodeRoles.contains(NodeRole.fromJsonName(role))) continue;
            return true;
        }
        return false;
    }
}

