/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import javax.validation.constraints.NotNull;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.log.FileRequestLogger;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.RequestLoggerProvider;
import org.joda.time.Duration;
import org.joda.time.Period;

@JsonTypeName(value="file")
public class FileRequestLoggerProvider
implements RequestLoggerProvider {
    private static final Logger log = new Logger(FileRequestLoggerProvider.class);
    @JsonProperty
    @NotNull
    private File dir = null;
    @JsonProperty
    @NotNull
    private String filePattern = "yyyy-MM-dd'.log'";
    @JacksonInject
    @NotNull
    private ScheduledExecutorFactory factory = null;
    @JacksonInject
    @NotNull
    @Json
    private ObjectMapper jsonMapper = null;
    @JsonProperty
    private Duration durationToRetain;
    @JsonProperty
    private Duration rollPeriod = new Period((Object)"P1D").toStandardDuration();

    public RequestLogger get() {
        FileRequestLogger logger = new FileRequestLogger(this.jsonMapper, this.factory.create(1, "RequestLogger-%s"), this.dir, this.filePattern, this.durationToRetain, this.rollPeriod);
        log.debug((Throwable)new Exception("Stack trace"), "Creating %s at", new Object[]{logger});
        return logger;
    }
}

