/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.server.coordinator.ServerCloneStatus;

public class CloneStatusManager {
    private final AtomicReference<Map<String, ServerCloneStatus>> cloneStatusSnapshot = new AtomicReference(Map.of());

    public List<ServerCloneStatus> getStatusForAllServers() {
        return List.copyOf(this.cloneStatusSnapshot.get().values());
    }

    @Nullable
    public ServerCloneStatus getStatusForServer(String targetServer) {
        return this.cloneStatusSnapshot.get().get(targetServer);
    }

    public void updateStatus(Map<String, ServerCloneStatus> newStatusMap) {
        this.cloneStatusSnapshot.set((Map<String, ServerCloneStatus>)ImmutableMap.copyOf(newStatusMap));
    }
}

