/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.JsonNonNull;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.audit.AuditManagerConfig;
import org.apache.druid.server.security.Escalator;

public class AuditSerdeHelper {
    private static final String PAYLOAD_TRUNCATED_MSG = "Payload truncated as it exceeds 'druid.audit.manager.maxPayloadSizeBytes'";
    private static final String SERIALIZE_ERROR_MSG = "Error serializing payload. Check logs for details.";
    private static final Logger log = new Logger(AuditSerdeHelper.class);
    private final ObjectMapper jsonMapper;
    private final ObjectMapper jsonMapperSkipNulls;
    private final String systemIdentity;
    private final AuditManagerConfig config;

    @Inject
    public AuditSerdeHelper(AuditManagerConfig config, Escalator escalator, @Json ObjectMapper jsonMapper, @JsonNonNull ObjectMapper jsonMapperSkipNulls) {
        this.config = config;
        this.jsonMapper = jsonMapper;
        this.jsonMapperSkipNulls = jsonMapperSkipNulls;
        this.systemIdentity = escalator == null ? null : escalator.createEscalatedAuthenticationResult().getIdentity();
    }

    public boolean shouldProcessAuditEntry(AuditEntry entry) {
        boolean isSystemRequest = this.systemIdentity != null && this.systemIdentity.equals(entry.getAuditInfo().getIdentity());
        return this.config.isAuditSystemRequests() || !isSystemRequest;
    }

    public AuditEntry processAuditEntry(AuditEntry entry) {
        AuditEntry.Payload payload = entry.getPayload();
        String serialized = payload.serialized() == null ? this.serializePayloadToString(payload.raw()) : payload.serialized();
        AuditEntry.Payload processedPayload = AuditEntry.Payload.fromString((String)this.truncateSerializedAuditPayload(serialized));
        return new AuditEntry(entry.getKey(), entry.getType(), entry.getAuditInfo(), entry.getRequest(), processedPayload, entry.getAuditTime());
    }

    private String serializePayloadToString(Object rawPayload) {
        if (rawPayload == null) {
            return "";
        }
        try {
            return this.config.isSkipNullField() ? this.jsonMapperSkipNulls.writeValueAsString(rawPayload) : this.jsonMapper.writeValueAsString(rawPayload);
        }
        catch (IOException e) {
            log.error((Throwable)e, "Could not serialize audit payload[%s]", new Object[]{rawPayload});
            return SERIALIZE_ERROR_MSG;
        }
    }

    private String truncateSerializedAuditPayload(String serializedPayload) {
        if (serializedPayload == null || this.config.getMaxPayloadSizeBytes() < 0L) {
            return serializedPayload;
        }
        int payloadSize = serializedPayload.getBytes(StandardCharsets.UTF_8).length;
        if ((long)payloadSize > this.config.getMaxPayloadSizeBytes()) {
            return PAYLOAD_TRUNCATED_MSG + StringUtils.format((String)"[%s].", (Object[])new Object[]{this.config.getMaxPayloadSizeBytes()});
        }
        return serializedPayload;
    }
}

