/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class SubqueryGuardrailHelper {
    private static final double SUBQUERY_MEMORY_BYTES_FRACTION = 0.5;
    private static final Logger log = new Logger(SubqueryGuardrailHelper.class);
    public static final String LIMIT_DISABLED_VALUE = "disabled";
    public static final String AUTO_LIMIT_VALUE = "auto";
    public static final Long LIMIT_DISABLED_REPRESENTATION = -1L;
    private final long autoLimitBytes;

    public SubqueryGuardrailHelper(LookupExtractorFactoryContainerProvider lookupManager, long maxMemoryInJvm, int maxConcurrentQueries) {
        DateTime start = DateTimes.nowUtc();
        this.autoLimitBytes = SubqueryGuardrailHelper.computeLimitBytesForAuto(lookupManager, maxMemoryInJvm, maxConcurrentQueries);
        long startupTimeMs = new Interval((ReadableInstant)start, (ReadableInstant)DateTimes.nowUtc()).toDurationMillis();
        log.info("Took [%d] ms to initialize the SubqueryGuardrailHelper.", new Object[]{startupTimeMs});
        if (startupTimeMs >= 10000L) {
            log.warn("Took more than 10 seconds to initialize the SubqueryGuardrailHelper. This happens when the lookup sizes are very large. Consider lowering the size of the lookups to reduce the initialization time.", new Object[0]);
        }
        log.info("Each query has a memory limit of [%d] bytes to materialize its subqueries' results if auto limit is used", new Object[]{this.autoLimitBytes});
    }

    public long convertSubqueryLimitStringToLong(String maxSubqueryLimit) {
        long retVal;
        if (LIMIT_DISABLED_VALUE.equalsIgnoreCase(maxSubqueryLimit)) {
            return LIMIT_DISABLED_REPRESENTATION;
        }
        if (AUTO_LIMIT_VALUE.equalsIgnoreCase(maxSubqueryLimit)) {
            return this.autoLimitBytes;
        }
        try {
            retVal = Long.parseLong(maxSubqueryLimit);
        }
        catch (NumberFormatException e) {
            throw InvalidInput.exception((Throwable)e, (String)"Unable to parse the provided maxSubqueryLimit [%s] to a valid number. Valid values for the maxSubqueryLimits can be 'auto', 'disabled' or a positive integer representing bytes to reserve.", (Object[])new Object[]{maxSubqueryLimit});
        }
        if (retVal < 0L) {
            throw InvalidInput.exception((String)"Limit too large", (Object[])new Object[0]);
        }
        return retVal;
    }

    private static long computeLimitBytesForAuto(LookupExtractorFactoryContainerProvider lookupManager, long maxMemoryInJvm, int maxConcurrentQueries) {
        long memoryInJvmWithoutLookups = maxMemoryInJvm - SubqueryGuardrailHelper.computeLookupFootprint(lookupManager);
        long memoryInJvmForSubqueryResultsInlining = (long)((double)memoryInJvmWithoutLookups * 0.5);
        long memoryInJvmForSubqueryResultsInliningPerQuery = memoryInJvmForSubqueryResultsInlining / (long)maxConcurrentQueries;
        return Math.max(memoryInJvmForSubqueryResultsInliningPerQuery, 1L);
    }

    private static long computeLookupFootprint(LookupExtractorFactoryContainerProvider lookupManager) {
        if (lookupManager == null || lookupManager.getAllLookupNames() == null) {
            log.warn("Failed to get the lookupManager for estimating lookup size. Skipping.", new Object[0]);
            return 0L;
        }
        int lookupCount = 0;
        long lookupFootprint = 0L;
        for (String lookupName : lookupManager.getAllLookupNames()) {
            LookupExtractorFactoryContainer container = lookupManager.get(lookupName).orElse(null);
            if (container == null) continue;
            try {
                LookupExtractor extractor = (LookupExtractor)container.getLookupExtractorFactory().get();
                lookupFootprint += extractor.estimateHeapFootprint();
                ++lookupCount;
            }
            catch (Exception e) {
                log.noStackTrace().warn((Throwable)e, "Failed to load lookup [%s] for size estimation. Skipping.", new Object[]{lookupName});
            }
        }
        log.debug("Lookup footprint: [%d] lookups with [%,d] total bytes.", new Object[]{lookupCount, lookupFootprint});
        return lookupFootprint;
    }
}

