/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentSchemaCache;

@ManageLifecycle
public class SqlSegmentsMetadataManagerV2
implements SegmentsMetadataManager {
    private static final Logger log = new Logger(SqlSegmentsMetadataManagerV2.class);
    private final SegmentsMetadataManager delegate;
    private final SegmentMetadataCache segmentMetadataCache;
    private final SegmentsMetadataManagerConfig managerConfig;

    public SqlSegmentsMetadataManagerV2(SegmentMetadataCache segmentMetadataCache, SegmentSchemaCache segmentSchemaCache, SQLMetadataConnector connector, Supplier<SegmentsMetadataManagerConfig> managerConfig, Supplier<MetadataStorageTablesConfig> tablesConfig, Supplier<CentralizedDatasourceSchemaConfig> centralizedDatasourceSchemaConfig, ServiceEmitter serviceEmitter, ObjectMapper jsonMapper) {
        this.delegate = new SqlSegmentsMetadataManager(jsonMapper, managerConfig, tablesConfig, connector, segmentSchemaCache, (CentralizedDatasourceSchemaConfig)centralizedDatasourceSchemaConfig.get(), serviceEmitter);
        this.managerConfig = (SegmentsMetadataManagerConfig)managerConfig.get();
        this.segmentMetadataCache = segmentMetadataCache;
    }

    private boolean useIncrementalCache() {
        return this.segmentMetadataCache.isEnabled();
    }

    @Override
    @LifecycleStart
    public void start() {
        this.delegate.start();
    }

    @Override
    @LifecycleStop
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public void startPollingDatabasePeriodically() {
        if (this.useIncrementalCache()) {
            log.info("Using segments in metadata cache to build timeline.", new Object[0]);
        } else {
            log.info("Starting poll of segments from metadata store.", new Object[0]);
            this.delegate.startPollingDatabasePeriodically();
        }
    }

    @Override
    public void stopPollingDatabasePeriodically() {
        if (!this.useIncrementalCache()) {
            log.info("Stopping poll of segments from metadata store.", new Object[0]);
            this.delegate.stopPollingDatabasePeriodically();
        }
    }

    @Override
    public boolean isPollingDatabasePeriodically() {
        return this.useIncrementalCache() || this.delegate.isPollingDatabasePeriodically();
    }

    @Override
    public DataSourcesSnapshot getRecentDataSourcesSnapshot() {
        if (this.useIncrementalCache()) {
            return this.segmentMetadataCache.getDataSourcesSnapshot();
        }
        return this.delegate.getRecentDataSourcesSnapshot();
    }

    @Override
    public DataSourcesSnapshot forceUpdateDataSourcesSnapshot() {
        if (this.useIncrementalCache()) {
            long timeoutMillis = this.managerConfig.getPollDuration().toStandardDuration().getMillis() * 2L;
            this.segmentMetadataCache.awaitNextSync(timeoutMillis);
            return this.segmentMetadataCache.getDataSourcesSnapshot();
        }
        return this.delegate.forceUpdateDataSourcesSnapshot();
    }

    @Override
    public void populateUsedFlagLastUpdatedAsync() {
        this.delegate.populateUsedFlagLastUpdatedAsync();
    }

    @Override
    public void stopAsyncUsedFlagLastUpdatedUpdate() {
        this.delegate.stopAsyncUsedFlagLastUpdatedUpdate();
    }
}

