/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.metadata.segment.cache.SegmentSchemaRecord;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class SqlSegmentsMetadataQuery {
    private static final Logger log = new Logger(SqlSegmentsMetadataQuery.class);
    private static final int MAX_INTERVALS_PER_BATCH = 100;
    private final Handle handle;
    private final SQLMetadataConnector connector;
    private final MetadataStorageTablesConfig dbTables;
    private final ObjectMapper jsonMapper;

    private SqlSegmentsMetadataQuery(Handle handle, SQLMetadataConnector connector, MetadataStorageTablesConfig dbTables, ObjectMapper jsonMapper) {
        this.handle = handle;
        this.connector = connector;
        this.dbTables = dbTables;
        this.jsonMapper = jsonMapper;
    }

    public static SqlSegmentsMetadataQuery forHandle(Handle handle, SQLMetadataConnector connector, MetadataStorageTablesConfig dbTables, ObjectMapper jsonMapper) {
        return new SqlSegmentsMetadataQuery(handle, connector, dbTables, jsonMapper);
    }

    @Nullable
    public static DateTime nullAndEmptySafeDate(String date) {
        return Strings.isNullOrEmpty((String)date) ? null : DateTimes.of((String)date);
    }

    public CloseableIterator<DataSegment> retrieveUsedSegments(String dataSource, Collection<Interval> intervals) {
        return this.retrieveUsedSegments(dataSource, intervals, null);
    }

    public CloseableIterator<DataSegment> retrieveUsedSegments(String dataSource, Collection<Interval> intervals, List<String> versions) {
        return this.retrieveSegments(dataSource, intervals, versions, IntervalMode.OVERLAPS, true, null, null, null, null);
    }

    public CloseableIterator<DataSegmentPlus> retrieveUsedSegmentsPlus(String dataSource, Collection<Interval> intervals) {
        return this.retrieveSegmentsPlus(dataSource, intervals, null, IntervalMode.OVERLAPS, true, null, null, null, null);
    }

    @Nullable
    public SegmentId retrieveHighestUnusedSegmentId(String datasource, Interval interval, String version) {
        Set<String> unusedSegmentIds = this.retrieveUnusedSegmentIdsForExactIntervalAndVersion(datasource, interval, version);
        log.debug("Found [%,d] unused segments for datasource[%s] for interval[%s] and version[%s].", new Object[]{unusedSegmentIds.size(), datasource, interval, version});
        SegmentId unusedMaxId = null;
        int maxPartitionNum = -1;
        for (String id : unusedSegmentIds) {
            SegmentId segmentId = IdUtils.getValidSegmentId((String)datasource, (String)id);
            int partitionNum = segmentId.getPartitionNum();
            if (maxPartitionNum >= partitionNum) continue;
            maxPartitionNum = partitionNum;
            unusedMaxId = segmentId;
        }
        return unusedMaxId;
    }

    private Set<String> retrieveUnusedSegmentIdsForExactIntervalAndVersion(String dataSource, Interval interval, String version) {
        String sql = StringUtils.format((String)"SELECT id FROM %1$s WHERE used = :used AND dataSource = :dataSource AND version = :version AND start = :start AND %2$send%2$s = :end", (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString()});
        Query query = (Query)((Query)((Query)((Query)((Query)this.handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize()).bind("used", false)).bind("dataSource", dataSource)).bind("version", version)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString());
        try (ResultIterator iterator = query.map((ResultSetMapper)StringMapper.FIRST).iterator();){
            ImmutableSet immutableSet = ImmutableSet.copyOf((Iterator)iterator);
            return immutableSet;
        }
    }

    public List<DataSegmentPlus> iterateAllUnusedSegmentsForDatasource(String datasource, @Nullable Interval interval, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder) {
        ImmutableList immutableList;
        block8: {
            Object intervals = interval == null ? Intervals.ONLY_ETERNITY : List.of(interval);
            CloseableIterator<DataSegmentPlus> iterator = this.retrieveUnusedSegmentsPlus(datasource, (Collection<Interval>)intervals, null, limit, lastSegmentId, sortOrder, null);
            try {
                immutableList = ImmutableList.copyOf(iterator);
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            iterator.close();
        }
        return immutableList;
    }

    public List<DataSegment> findUnusedSegments(String dataSource, Interval interval, @Nullable List<String> versions, @Nullable Integer limit, @Nullable DateTime maxUpdatedTime) {
        ImmutableList immutableList;
        block8: {
            CloseableIterator<DataSegment> iterator = this.retrieveUnusedSegments(dataSource, List.of(interval), versions, limit, null, null, maxUpdatedTime);
            try {
                immutableList = ImmutableList.copyOf(iterator);
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw InternalServerError.exception((Throwable)e, (String)"Error while reading unused segments", (Object[])new Object[0]);
                }
            }
            iterator.close();
        }
        return immutableList;
    }

    public CloseableIterator<DataSegment> retrieveUnusedSegments(String dataSource, Collection<Interval> intervals, @Nullable List<String> versions, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        return this.retrieveSegments(dataSource, intervals, versions, IntervalMode.CONTAINS, false, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);
    }

    public CloseableIterator<DataSegmentPlus> retrieveUnusedSegmentsPlus(String dataSource, Collection<Interval> intervals, @Nullable List<String> versions, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        return this.retrieveSegmentsPlus(dataSource, intervals, versions, IntervalMode.CONTAINS, false, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);
    }

    public Set<SegmentId> retrieveUsedSegmentIds(String dataSource, Interval interval) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT id FROM %s WHERE used = :used AND dataSource = :dataSource");
        boolean compareAsString = Intervals.canCompareEndpointsAsStrings((Interval)interval);
        if (compareAsString) {
            sb.append(SqlSegmentsMetadataQuery.getConditionForIntervalsAndMatchMode(Collections.singletonList(interval), IntervalMode.OVERLAPS, this.connector.getQuoteString()));
        }
        Query sql = (Query)((Query)this.handle.createQuery(StringUtils.format((String)sb.toString(), (Object[])new Object[]{this.dbTables.getSegmentsTable()})).setFetchSize(this.connector.getStreamingFetchSize()).bind("used", true)).bind("dataSource", dataSource);
        if (compareAsString) {
            SqlSegmentsMetadataQuery.bindIntervalsToQuery((Query<Map<String, Object>>)sql, Collections.singletonList(interval));
        }
        HashSet<SegmentId> segmentIds = new HashSet<SegmentId>();
        try (ResultIterator iterator = sql.map((ResultSetMapper)StringMapper.FIRST).iterator();){
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                SegmentId segmentId = SegmentId.tryParse((String)dataSource, (String)id);
                if (segmentId == null) {
                    throw DruidException.defensive((String)"Failed to parse SegmentId for id[%s] and dataSource[%s].", (Object[])new Object[]{id, dataSource});
                }
                if (!IntervalMode.OVERLAPS.apply(interval, segmentId.getInterval())) continue;
                segmentIds.add(segmentId);
            }
        }
        return segmentIds;
    }

    public List<DataSegmentPlus> retrieveSegmentsById(String datasource, Set<SegmentId> segmentIds) {
        ImmutableList immutableList;
        block8: {
            CloseableIterator<DataSegmentPlus> iterator = this.retrieveSegmentsByIdIterator(datasource, segmentIds, false);
            try {
                immutableList = ImmutableList.copyOf(iterator);
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw DruidException.defensive((Throwable)e, (String)"Error while retrieving segments from metadata store", (Object[])new Object[0]);
                }
            }
            iterator.close();
        }
        return immutableList;
    }

    public CloseableIterator<DataSegmentPlus> retrieveSegmentsByIdIterator(final String datasource, Set<SegmentId> segmentIds, final boolean includeSchemaInfo) {
        List ids = segmentIds.stream().map(SegmentId::toString).collect(Collectors.toList());
        final List partitionedSegmentIds = Lists.partition(ids, (int)100);
        return new CloseableIterator<DataSegmentPlus>(){
            CloseableIterator<DataSegmentPlus> currentBatch = CloseableIterators.withEmptyBaggage(Collections.emptyIterator());
            int currentBatchIndex = -1;

            public void close() throws IOException {
                this.currentBatch.close();
            }

            public boolean hasNext() {
                if (this.currentBatch.hasNext()) {
                    return true;
                }
                if (++this.currentBatchIndex < partitionedSegmentIds.size()) {
                    CloseableUtils.closeAndWrapExceptions(this.currentBatch);
                    this.currentBatch = SqlSegmentsMetadataQuery.this.retrieveSegmentBatchById(datasource, (List)partitionedSegmentIds.get(this.currentBatchIndex), includeSchemaInfo);
                    return this.hasNext();
                }
                return false;
            }

            public DataSegmentPlus next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (DataSegmentPlus)this.currentBatch.next();
            }
        };
    }

    public List<DataSegmentPlus> retrieveSegmentsWithSchemaById(String datasource, Set<SegmentId> segmentIds) {
        ImmutableList immutableList;
        block8: {
            CloseableIterator<DataSegmentPlus> iterator = this.retrieveSegmentsByIdIterator(datasource, segmentIds, true);
            try {
                immutableList = ImmutableList.copyOf(iterator);
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw DruidException.defensive((Throwable)e, (String)"Error while retrieving segments with schema from metadata store.", (Object[])new Object[0]);
                }
            }
            iterator.close();
        }
        return immutableList;
    }

    private CloseableIterator<DataSegmentPlus> retrieveSegmentBatchById(String datasource, List<String> segmentIds, boolean includeSchemaInfo) {
        ResultIterator resultIterator;
        if (segmentIds.isEmpty()) {
            return CloseableIterators.withEmptyBaggage(Collections.emptyIterator());
        }
        if (includeSchemaInfo) {
            Query query = this.handle.createQuery(StringUtils.format((String)"SELECT payload, used, schema_fingerprint, num_rows, upgraded_from_segment_id, used_status_last_updated FROM %s WHERE dataSource = :dataSource %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("id", segmentIds)}));
            SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("id", segmentIds, query);
            resultIterator = ((Query)query.bind("dataSource", datasource)).setFetchSize(this.connector.getStreamingFetchSize()).map((index, r, ctx) -> {
                String schemaFingerprint = (String)r.getObject(3);
                Long numRows = (Long)r.getObject(4);
                return new DataSegmentPlus((DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class), null, SqlSegmentsMetadataQuery.nullAndEmptySafeDate(r.getString(6)), r.getBoolean(2), schemaFingerprint, numRows, r.getString(5));
            }).iterator();
        } else {
            Query query = this.handle.createQuery(StringUtils.format((String)"SELECT payload, used, upgraded_from_segment_id, used_status_last_updated, created_date FROM %s WHERE dataSource = :dataSource %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("id", segmentIds)}));
            SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("id", segmentIds, query);
            resultIterator = ((Query)query.bind("dataSource", datasource)).setFetchSize(this.connector.getStreamingFetchSize()).map((index, r, ctx) -> new DataSegmentPlus((DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class), DateTimes.of((String)r.getString(5)), SqlSegmentsMetadataQuery.nullAndEmptySafeDate(r.getString(4)), r.getBoolean(2), null, null, r.getString(3))).iterator();
        }
        return CloseableIterators.wrap((Iterator)resultIterator, (Closeable)resultIterator);
    }

    public Set<String> retrieveAllUsedSegmentSchemaFingerprints() {
        String sql = StringUtils.format((String)"SELECT fingerprint FROM %s WHERE version = %s AND used = true", (Object[])new Object[]{this.dbTables.getSegmentSchemasTable(), 1});
        return Set.copyOf(this.handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize()).mapTo(String.class).list());
    }

    public List<SegmentSchemaRecord> retrieveAllUsedSegmentSchemas() {
        String sql = StringUtils.format((String)"SELECT fingerprint, payload FROM %s WHERE version = %s AND used = true", (Object[])new Object[]{this.dbTables.getSegmentSchemasTable(), 1});
        return this.retrieveValidSchemaRecordsWithQuery((Query<Map<String, Object>>)this.handle.createQuery(sql));
    }

    public List<SegmentSchemaRecord> retrieveUsedSegmentSchemasForFingerprints(Set<String> schemaFingerprints) {
        List fingerprintBatches = Lists.partition(List.copyOf(schemaFingerprints), (int)100);
        ArrayList<SegmentSchemaRecord> records = new ArrayList<SegmentSchemaRecord>();
        for (List fingerprintBatch : fingerprintBatches) {
            records.addAll(this.retrieveBatchOfSegmentSchemas(fingerprintBatch));
        }
        return records;
    }

    private List<SegmentSchemaRecord> retrieveBatchOfSegmentSchemas(List<String> schemaFingerprints) {
        String sql = StringUtils.format((String)"SELECT fingerprint, payload FROM %s WHERE version = %s AND used = true %s", (Object[])new Object[]{this.dbTables.getSegmentSchemasTable(), 1, SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("fingerprint", schemaFingerprints)});
        Query query = this.handle.createQuery(sql);
        SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("fingerprint", schemaFingerprints, query);
        return this.retrieveValidSchemaRecordsWithQuery((Query<Map<String, Object>>)query);
    }

    private List<SegmentSchemaRecord> retrieveValidSchemaRecordsWithQuery(Query<Map<String, Object>> query) {
        return query.setFetchSize(this.connector.getStreamingFetchSize()).map((index, r, ctx) -> this.mapToSchemaRecord(r)).list().stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public int markSegmentsAsUsed(Set<SegmentId> segmentIds, DateTime updateTime) {
        return this.markSegments(segmentIds, true, updateTime);
    }

    public int markSegmentsAsUnused(Set<SegmentId> segmentIds, DateTime updateTime) {
        return this.markSegments(segmentIds, false, updateTime);
    }

    private int markSegments(Set<SegmentId> segmentIds, boolean used, DateTime updateTime) {
        if (segmentIds.isEmpty()) {
            return 0;
        }
        String dataSource = segmentIds.iterator().next().getDataSource();
        if (segmentIds.stream().anyMatch(segment -> !dataSource.equals(segment.getDataSource()))) {
            throw new IAE("Segments to drop must all be part of the same datasource", new Object[0]);
        }
        PreparedBatch batch = this.handle.prepareBatch(StringUtils.format((String)"UPDATE %s SET used = ?, used_status_last_updated = ? WHERE datasource = ? AND id = ?", (Object[])new Object[]{this.dbTables.getSegmentsTable()}));
        for (SegmentId segmentId : segmentIds) {
            batch.add(new Object[]{used, updateTime.toString(), dataSource, segmentId.toString()});
        }
        int[] segmentChanges = batch.execute();
        return SqlSegmentsMetadataQuery.computeNumChangedSegments(segmentIds.stream().map(SegmentId::toString).collect(Collectors.toList()), segmentChanges);
    }

    public int markSegmentsUnused(String dataSource, Interval interval, @Nullable List<String> versions, DateTime updateTime) {
        if (versions != null && versions.isEmpty()) {
            return 0;
        }
        if (Intervals.isEternity((Interval)interval)) {
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtils.format((String)"UPDATE %s SET used=:used, used_status_last_updated = :used_status_last_updated WHERE dataSource = :dataSource AND used = true", (Object[])new Object[]{this.dbTables.getSegmentsTable()}));
            if (versions != null) {
                sb.append(SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("version", versions));
            }
            Update stmt = (Update)((Update)((Update)this.handle.createStatement(sb.toString()).bind("dataSource", dataSource)).bind("used", false)).bind("used_status_last_updated", updateTime.toString());
            if (versions != null) {
                SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("version", versions, stmt);
            }
            return stmt.execute();
        }
        if (Intervals.canCompareEndpointsAsStrings((Interval)interval) && interval.getStart().getYear() == interval.getEnd().getYear()) {
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtils.format((String)"UPDATE %s SET used=:used, used_status_last_updated = :used_status_last_updated WHERE dataSource = :dataSource AND used = true AND %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), IntervalMode.CONTAINS.makeSqlCondition(this.connector.getQuoteString(), ":start", ":end")}));
            if (versions != null) {
                sb.append(SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("version", versions));
            }
            Update stmt = (Update)((Update)((Update)((Update)((Update)this.handle.createStatement(sb.toString()).bind("dataSource", dataSource)).bind("used", false)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).bind("used_status_last_updated", updateTime.toString());
            if (versions != null) {
                SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("version", versions, stmt);
            }
            return stmt.execute();
        }
        ImmutableSet segments = ImmutableSet.copyOf((Iterator)Iterators.transform(this.retrieveSegments(dataSource, Collections.singletonList(interval), versions, IntervalMode.CONTAINS, true, null, null, null, null), DataSegment::getId));
        return this.markSegments((Set<SegmentId>)segments, false, updateTime);
    }

    public boolean markSegmentAsUsed(SegmentId segmentId, DateTime updateTime) {
        return this.markSegments(Set.of(segmentId), true, updateTime) > 0;
    }

    public int markAllNonOvershadowedSegmentsAsUsed(String dataSource, DateTime updateTime) {
        return this.markNonOvershadowedSegmentsAsUsedInternal(dataSource, null, null, updateTime);
    }

    public int markNonOvershadowedSegmentsAsUsed(String dataSource, Interval interval, @Nullable List<String> versions, DateTime updateTime) {
        Preconditions.checkNotNull((Object)interval);
        return this.markNonOvershadowedSegmentsAsUsedInternal(dataSource, interval, versions, updateTime);
    }

    private int markNonOvershadowedSegmentsAsUsedInternal(String dataSourceName, @Nullable Interval interval, @Nullable List<String> versions, DateTime updateTime) {
        CloseableIterator<DataSegment> iterator;
        ArrayList<DataSegment> unusedSegments = new ArrayList<DataSegment>();
        SegmentTimeline timeline = new SegmentTimeline();
        Object intervals = interval == null ? Intervals.ONLY_ETERNITY : Collections.singletonList(interval);
        try {
            iterator = this.retrieveUsedSegments(dataSourceName, (Collection<Interval>)intervals, versions);
            try {
                timeline.addSegments(iterator);
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            iterator = this.retrieveUnusedSegments(dataSourceName, (Collection<Interval>)intervals, versions, null, null, null, null);
            try {
                while (iterator.hasNext()) {
                    DataSegment dataSegment = (DataSegment)iterator.next();
                    timeline.add(dataSegment);
                    unusedSegments.add(dataSegment);
                }
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.markNonOvershadowedSegmentsAsUsed(unusedSegments, timeline, updateTime);
    }

    private int markNonOvershadowedSegmentsAsUsed(List<DataSegment> unusedSegments, SegmentTimeline timeline, DateTime updateTime) {
        Set<SegmentId> nonOvershadowedSegments = unusedSegments.stream().filter(segment -> !timeline.isOvershadowed(segment)).map(DataSegment::getId).collect(Collectors.toSet());
        return this.markSegmentsAsUsed(nonOvershadowedSegments, updateTime);
    }

    public int markNonOvershadowedSegmentsAsUsed(String dataSource, Set<SegmentId> segmentIds, DateTime updateTime) {
        List<DataSegment> unusedSegments = this.retrieveUnusedSegments(dataSource, segmentIds);
        List unusedSegmentsIntervals = JodaUtils.condenseIntervals((Iterable)unusedSegments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
        SegmentTimeline timeline = SegmentTimeline.forSegments(unusedSegments);
        try (CloseableIterator<DataSegment> usedSegmentsOverlappingUnusedSegmentsIntervals = this.retrieveUsedSegments(dataSource, unusedSegmentsIntervals);){
            timeline.addSegments(usedSegmentsOverlappingUnusedSegmentsIntervals);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.markNonOvershadowedSegmentsAsUsed(unusedSegments, timeline, updateTime);
    }

    private List<DataSegment> retrieveUnusedSegments(String dataSource, Set<SegmentId> segmentIds) {
        List<DataSegmentPlus> retrievedSegments = this.retrieveSegmentsById(dataSource, segmentIds);
        HashSet<SegmentId> unknownSegmentIds = new HashSet<SegmentId>(segmentIds);
        ArrayList<DataSegment> unusedSegments = new ArrayList<DataSegment>();
        for (DataSegmentPlus entry : retrievedSegments) {
            DataSegment segment = entry.getDataSegment();
            unknownSegmentIds.remove(segment.getId());
            if (!Boolean.FALSE.equals(entry.getUsed())) continue;
            unusedSegments.add(segment);
        }
        if (!unknownSegmentIds.isEmpty()) {
            throw InvalidInput.exception((String)"Could not find segment IDs[%s] for datasource[%s]", (Object[])new Object[]{unknownSegmentIds, dataSource});
        }
        return unusedSegments;
    }

    public List<Interval> retrieveUnusedSegmentIntervals(String dataSource, @Nullable DateTime minStartTime, DateTime maxEndTime, int limit, DateTime maxUsedStatusLastUpdatedTime) {
        boolean filterByStartTime = minStartTime != null;
        String sql = StringUtils.format((String)"SELECT start, %2$send%2$s FROM %1$s WHERE dataSource = :dataSource AND used = false AND %2$send%2$s <= :end %3$s AND used_status_last_updated IS NOT NULL AND used_status_last_updated <= :used_status_last_updated ORDER BY start, %2$send%2$s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString(), filterByStartTime ? " AND start >= :start" : ""});
        Query query = (Query)((Query)((Query)this.handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize()).setMaxRows(limit).bind("dataSource", dataSource)).bind("end", maxEndTime.toString())).bind("used_status_last_updated", maxUsedStatusLastUpdatedTime.toString());
        if (filterByStartTime) {
            query.bind("start", minStartTime.toString());
        }
        List unusedIntervals = query.map((index, r, ctx) -> this.mapToInterval(r, dataSource)).list();
        return unusedIntervals.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Interval> retrieveUnusedSegmentIntervals(String dataSource, int limit) {
        String sql = StringUtils.format((String)"SELECT start, %2$send%2$s FROM %1$s WHERE dataSource = :dataSource AND used = false GROUP BY start, %2$send%2$s  %3$s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString(), this.connector.limitClause(limit)});
        List intervals = (List)this.connector.inReadOnlyTransaction((handle, status) -> ((Query)handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize()).bind("dataSource", dataSource)).map((index, r, ctx) -> this.mapToInterval(r, dataSource)).list());
        return intervals.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DataSegment> retrieveUnusedSegmentsWithExactInterval(String dataSource, Interval interval, DateTime maxUpdatedTime, int limit) {
        String sql = StringUtils.format((String)"SELECT id, payload FROM %1$s WHERE dataSource = :dataSource AND used = false AND %2$send%2$s = :end AND start = :start AND (used_status_last_updated IS NULL OR used_status_last_updated <= :maxUpdatedTime)  %3$s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString(), this.connector.limitClause(limit)});
        List segments = (List)this.connector.inReadOnlyTransaction((handle, status) -> ((Query)((Query)((Query)((Query)handle.createQuery(sql).setFetchSize(this.connector.getStreamingFetchSize()).bind("dataSource", dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).bind("maxUpdatedTime", maxUpdatedTime.toString())).map((index, r, ctx) -> this.mapToSegment(r)).list());
        return segments.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<String> retrieveUnusedSegmentVersionsWithInterval(String dataSource, Interval interval) {
        String sql = StringUtils.format((String)"SELECT DISTINCT(version) FROM %1$s WHERE dataSource = :dataSource AND used = false AND %2$send%2$s = :end AND start = :start", (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString()});
        return Set.copyOf(((Query)((Query)((Query)this.handle.createQuery(sql).bind("dataSource", dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).mapTo(String.class).list());
    }

    @Nullable
    public DataSegment retrieveUsedSegmentForId(SegmentId segmentId) {
        String query = "SELECT payload FROM %s WHERE used = true AND id = :id";
        List segments = ((Query)this.handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE used = true AND id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()})).bind("id", segmentId.toString())).map((index, r, ctx) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class)).list();
        return segments.isEmpty() ? null : (DataSegment)segments.get(0);
    }

    @Nullable
    public DataSegment retrieveSegmentForId(SegmentId segmentId) {
        String query = "SELECT payload FROM %s WHERE id = :id";
        List segments = ((Query)this.handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()})).bind("id", segmentId.toString())).map((index, r, ctx) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(1), DataSegment.class)).list();
        return segments.isEmpty() ? null : (DataSegment)segments.get(0);
    }

    public List<SegmentIdWithShardSpec> retrievePendingSegmentIds(String dataSource, String sequenceName, String sequencePreviousId) {
        String sql = StringUtils.format((String)"SELECT payload FROM %s WHERE dataSource = :dataSource AND sequence_name = :sequence_name AND sequence_prev_id = :sequence_prev_id", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()});
        return ((Query)((Query)((Query)this.handle.createQuery(sql).bind("dataSource", dataSource)).bind("sequence_name", sequenceName)).bind("sequence_prev_id", sequencePreviousId)).map((index, r, ctx) -> (SegmentIdWithShardSpec)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes("payload"), SegmentIdWithShardSpec.class)).list();
    }

    public List<SegmentIdWithShardSpec> retrievePendingSegmentIdsWithExactInterval(String dataSource, String sequenceName, Interval interval) {
        String sql = StringUtils.format((String)"SELECT payload FROM %s WHERE dataSource = :dataSource AND sequence_name = :sequence_name AND start = :start AND %2$send%2$s = :end", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), this.connector.getQuoteString()});
        return ((Query)((Query)((Query)((Query)this.handle.createQuery(sql).bind("dataSource", dataSource)).bind("sequence_name", sequenceName)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).map((index, r, ctx) -> (SegmentIdWithShardSpec)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes("payload"), SegmentIdWithShardSpec.class)).list();
    }

    public List<PendingSegmentRecord> retrievePendingSegmentsWithExactInterval(String dataSource, Interval interval) {
        String sql = StringUtils.format((String)"SELECT payload, sequence_name, sequence_prev_id, task_allocator_id, upgraded_from_segment_id, created_date FROM %1$s WHERE dataSource = :dataSource AND start = :start AND %2$send%2$s = :end", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), this.connector.getQuoteString()});
        return ((Query)((Query)((Query)this.handle.createQuery(sql).bind("dataSource", dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).map((index, r, ctx) -> PendingSegmentRecord.fromResultSet(r, this.jsonMapper)).list();
    }

    public List<PendingSegmentRecord> retrievePendingSegmentsOverlappingInterval(String dataSource, Interval interval) {
        boolean compareIntervalEndpointsAsStrings = Intervals.canCompareEndpointsAsStrings((Interval)interval);
        Object sql = StringUtils.format((String)"SELECT payload, sequence_name, sequence_prev_id, task_allocator_id, upgraded_from_segment_id, created_date FROM %1$s WHERE dataSource = :dataSource", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()});
        if (compareIntervalEndpointsAsStrings) {
            sql = (String)sql + " AND start < :end" + StringUtils.format((String)" AND %1$send%1$s > :start", (Object[])new Object[]{this.connector.getQuoteString()});
        }
        Query query = (Query)this.handle.createQuery((String)sql).bind("dataSource", dataSource);
        if (compareIntervalEndpointsAsStrings) {
            query = (Query)((Query)query.bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString());
        }
        ResultIterator pendingSegmentIterator = query.map((index, r, ctx) -> PendingSegmentRecord.fromResultSet(r, this.jsonMapper)).iterator();
        ImmutableList.Builder pendingSegments = ImmutableList.builder();
        while (pendingSegmentIterator.hasNext()) {
            PendingSegmentRecord pendingSegment = (PendingSegmentRecord)pendingSegmentIterator.next();
            if (!compareIntervalEndpointsAsStrings && !pendingSegment.getId().getInterval().overlaps((ReadableInterval)interval)) continue;
            pendingSegments.add((Object)pendingSegment);
        }
        pendingSegmentIterator.close();
        return pendingSegments.build();
    }

    public List<PendingSegmentRecord> retrievePendingSegmentsForTaskAllocatorId(String dataSource, String taskAllocatorId) {
        String sql = StringUtils.format((String)"SELECT payload, sequence_name, sequence_prev_id, task_allocator_id, upgraded_from_segment_id, created_date FROM %1$s WHERE dataSource = :dataSource AND task_allocator_id = :task_allocator_id", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()});
        Query query = (Query)((Query)this.handle.createQuery(sql).bind("dataSource", dataSource)).bind("task_allocator_id", taskAllocatorId);
        ResultIterator pendingSegmentRecords = query.map((index, r, ctx) -> PendingSegmentRecord.fromResultSet(r, this.jsonMapper)).iterator();
        ArrayList<PendingSegmentRecord> pendingSegments = new ArrayList<PendingSegmentRecord>();
        while (pendingSegmentRecords.hasNext()) {
            pendingSegments.add((PendingSegmentRecord)pendingSegmentRecords.next());
        }
        pendingSegmentRecords.close();
        return pendingSegments;
    }

    public static String getConditionForIntervalsAndMatchMode(Collection<Interval> intervals, IntervalMode matchMode, String quoteString) {
        if (intervals.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" AND (");
        for (int i = 0; i < intervals.size(); ++i) {
            sb.append(matchMode.makeSqlCondition(quoteString, StringUtils.format((String)":start%d", (Object[])new Object[]{i}), StringUtils.format((String)":end%d", (Object[])new Object[]{i})));
            if (matchMode.equals((Object)IntervalMode.OVERLAPS)) {
                sb.append(StringUtils.format((String)" OR (start = '%s' AND \"end\" != '%s' AND \"end\" > :start%d)", (Object[])new Object[]{Intervals.ETERNITY.getStart(), Intervals.ETERNITY.getEnd(), i}));
                sb.append(StringUtils.format((String)" OR (start != '%s' AND \"end\" = '%s' AND start < :end%d)", (Object[])new Object[]{Intervals.ETERNITY.getStart(), Intervals.ETERNITY.getEnd(), i}));
            }
            if (i == intervals.size() - 1) continue;
            sb.append(" OR ");
        }
        if (matchMode.equals((Object)IntervalMode.OVERLAPS)) {
            sb.append(StringUtils.format((String)" OR (start = '%s' AND \"end\" = '%s')", (Object[])new Object[]{Intervals.ETERNITY.getStart(), Intervals.ETERNITY.getEnd()}));
        }
        sb.append(")");
        return sb.toString();
    }

    public static void bindIntervalsToQuery(Query<Map<String, Object>> query, Collection<Interval> intervals) {
        if (intervals.isEmpty()) {
            return;
        }
        Iterator<Interval> iterator = intervals.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Interval interval = iterator.next();
            ((Query)query.bind(StringUtils.format((String)"start%d", (Object[])new Object[]{i}), interval.getStart().toString())).bind(StringUtils.format((String)"end%d", (Object[])new Object[]{i}), interval.getEnd().toString());
            ++i;
        }
    }

    private CloseableIterator<DataSegment> retrieveSegments(String dataSource, Collection<Interval> intervals, @Nullable List<String> versions, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        if (versions != null && versions.isEmpty()) {
            return CloseableIterators.withEmptyBaggage(Collections.emptyIterator());
        }
        if (intervals.isEmpty() || intervals.size() <= 100) {
            return CloseableIterators.withEmptyBaggage(this.retrieveSegmentsInIntervalsBatch(dataSource, intervals, versions, matchMode, used, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime));
        }
        List intervalsLists = Lists.partition(new ArrayList<Interval>(intervals), (int)100);
        ArrayList<Iterator<Object>> resultingIterators = new ArrayList<Iterator<Object>>();
        Integer limitPerBatch = limit;
        for (List intervalList : intervalsLists) {
            UnmodifiableIterator<DataSegment> iterator = this.retrieveSegmentsInIntervalsBatch(dataSource, intervalList, versions, matchMode, used, limitPerBatch, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);
            if (limitPerBatch != null) {
                ImmutableList dataSegments = ImmutableList.copyOf(iterator);
                resultingIterators.add(dataSegments.iterator());
                if (dataSegments.size() >= limitPerBatch) break;
                limitPerBatch = limitPerBatch - dataSegments.size();
                continue;
            }
            resultingIterators.add((Iterator<Object>)iterator);
        }
        return CloseableIterators.withEmptyBaggage((Iterator)Iterators.concat(resultingIterators.iterator()));
    }

    private CloseableIterator<DataSegmentPlus> retrieveSegmentsPlus(String dataSource, Collection<Interval> intervals, @Nullable List<String> versions, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        if (intervals.isEmpty() || intervals.size() <= 100) {
            return CloseableIterators.withEmptyBaggage(this.retrieveSegmentsPlusInIntervalsBatch(dataSource, intervals, versions, matchMode, used, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime));
        }
        List intervalsLists = Lists.partition(new ArrayList<Interval>(intervals), (int)100);
        ArrayList<Iterator<Object>> resultingIterators = new ArrayList<Iterator<Object>>();
        Integer limitPerBatch = limit;
        for (List intervalList : intervalsLists) {
            UnmodifiableIterator<DataSegmentPlus> iterator = this.retrieveSegmentsPlusInIntervalsBatch(dataSource, intervalList, versions, matchMode, used, limitPerBatch, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime);
            if (limitPerBatch != null) {
                ImmutableList dataSegments = ImmutableList.copyOf(iterator);
                resultingIterators.add(dataSegments.iterator());
                if (dataSegments.size() >= limitPerBatch) break;
                limitPerBatch = limitPerBatch - dataSegments.size();
                continue;
            }
            resultingIterators.add((Iterator<Object>)iterator);
        }
        return CloseableIterators.withEmptyBaggage((Iterator)Iterators.concat(resultingIterators.iterator()));
    }

    private UnmodifiableIterator<DataSegment> retrieveSegmentsInIntervalsBatch(String dataSource, Collection<Interval> intervals, @Nullable List<String> versions, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        Query<Map<String, Object>> sql = this.buildSegmentsTableQuery(dataSource, intervals, versions, matchMode, used, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime, false);
        ResultIterator<DataSegment> resultIterator = this.getDataSegmentResultIterator(sql);
        return this.filterDataSegmentIteratorByInterval(resultIterator, intervals, matchMode);
    }

    private UnmodifiableIterator<DataSegmentPlus> retrieveSegmentsPlusInIntervalsBatch(String dataSource, Collection<Interval> intervals, @Nullable List<String> versions, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        Query<Map<String, Object>> sql = this.buildSegmentsTableQuery(dataSource, intervals, versions, matchMode, used, limit, lastSegmentId, sortOrder, maxUsedStatusLastUpdatedTime, true);
        ResultIterator<DataSegmentPlus> resultIterator = this.getDataSegmentPlusResultIterator(sql, used);
        return this.filterDataSegmentPlusIteratorByInterval(resultIterator, intervals, matchMode);
    }

    private Query<Map<String, Object>> buildSegmentsTableQuery(String dataSource, Collection<Interval> intervals, @Nullable List<String> versions, IntervalMode matchMode, boolean used, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder, @Nullable DateTime maxUsedStatusLastUpdatedTime, boolean includeExtraInfo) {
        boolean addMaxUsedLastUpdatedTimeFilter;
        boolean compareAsString = intervals.stream().allMatch(Intervals::canCompareEndpointsAsStrings);
        StringBuilder sb = new StringBuilder();
        if (includeExtraInfo) {
            sb.append("SELECT id, payload, created_date, used_status_last_updated FROM %s WHERE used = :used AND dataSource = :dataSource");
        } else {
            sb.append("SELECT id, payload FROM %s WHERE used = :used AND dataSource = :dataSource");
        }
        if (compareAsString) {
            sb.append(SqlSegmentsMetadataQuery.getConditionForIntervalsAndMatchMode(intervals, matchMode, this.connector.getQuoteString()));
        }
        if (versions != null) {
            sb.append(SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("version", versions));
        }
        boolean bl = addMaxUsedLastUpdatedTimeFilter = !used && maxUsedStatusLastUpdatedTime != null;
        if (addMaxUsedLastUpdatedTimeFilter) {
            sb.append(" AND (used_status_last_updated IS NOT NULL AND used_status_last_updated <= :used_status_last_updated)");
        }
        if (lastSegmentId != null) {
            sb.append(StringUtils.format((String)" AND id %s :id", (Object[])new Object[]{sortOrder == null || sortOrder == SortOrder.ASC ? ">" : "<"}));
        }
        if (sortOrder != null) {
            sb.append(StringUtils.format((String)" ORDER BY id %2$s, start %2$s, %1$send%1$s %2$s", (Object[])new Object[]{this.connector.getQuoteString(), sortOrder.toString()}));
        }
        Query sql = (Query)((Query)this.handle.createQuery(StringUtils.format((String)sb.toString(), (Object[])new Object[]{this.dbTables.getSegmentsTable()})).setFetchSize(this.connector.getStreamingFetchSize()).bind("used", used)).bind("dataSource", dataSource);
        if (addMaxUsedLastUpdatedTimeFilter) {
            sql.bind("used_status_last_updated", maxUsedStatusLastUpdatedTime.toString());
        }
        if (lastSegmentId != null) {
            sql.bind("id", lastSegmentId);
        }
        if (limit != null) {
            sql.setMaxRows(limit.intValue());
        }
        if (compareAsString) {
            SqlSegmentsMetadataQuery.bindIntervalsToQuery((Query<Map<String, Object>>)sql, intervals);
        }
        if (versions != null) {
            SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("version", versions, sql);
        }
        return sql;
    }

    @Nullable
    private Interval mapToInterval(ResultSet resultSet, String dataSource) {
        try {
            return new Interval((ReadableInstant)DateTimes.of((String)resultSet.getString("start")), (ReadableInstant)DateTimes.of((String)resultSet.getString("end")));
        }
        catch (Throwable t) {
            log.error(t, "Could not read an interval of datasource[%s]", new Object[]{dataSource});
            return null;
        }
    }

    @Nullable
    private SegmentSchemaRecord mapToSchemaRecord(ResultSet resultSet) {
        String fingerprint = null;
        try {
            fingerprint = resultSet.getString("fingerprint");
            return new SegmentSchemaRecord(fingerprint, (SchemaPayload)this.jsonMapper.readValue(resultSet.getBytes("payload"), SchemaPayload.class));
        }
        catch (Throwable t) {
            log.error(t, "Could not read segment schema with fingerprint[%s]", new Object[]{fingerprint});
            return null;
        }
    }

    private ResultIterator<DataSegment> getDataSegmentResultIterator(Query<Map<String, Object>> sql) {
        return sql.map((index, r, ctx) -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(2), DataSegment.class)).iterator();
    }

    private ResultIterator<DataSegmentPlus> getDataSegmentPlusResultIterator(Query<Map<String, Object>> sql, boolean used) {
        return sql.map((index, r, ctx) -> {
            String segmentId = r.getString(1);
            try {
                return new DataSegmentPlus((DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])r.getBytes(2), DataSegment.class), DateTimes.of((String)r.getString(3)), SqlSegmentsMetadataQuery.nullAndEmptySafeDate(r.getString(4)), used, null, null, null);
            }
            catch (Throwable t) {
                log.error(t, "Could not read segment with ID[%s]", new Object[]{segmentId});
                return null;
            }
        }).iterator();
    }

    @Nullable
    private DataSegment mapToSegment(ResultSet resultSet) {
        String segmentId = "";
        try {
            segmentId = resultSet.getString("id");
            return (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])resultSet.getBytes("payload"), DataSegment.class);
        }
        catch (Throwable t) {
            log.error(t, "Could not read segment with ID[%s]", new Object[]{segmentId});
            return null;
        }
    }

    private UnmodifiableIterator<DataSegment> filterDataSegmentIteratorByInterval(ResultIterator<DataSegment> resultIterator, Collection<Interval> intervals, IntervalMode matchMode) {
        return Iterators.filter(resultIterator, dataSegment -> {
            if (intervals.isEmpty()) {
                return true;
            }
            for (Interval interval : intervals) {
                if (!matchMode.apply(interval, dataSegment.getInterval())) continue;
                return true;
            }
            return false;
        });
    }

    private UnmodifiableIterator<DataSegmentPlus> filterDataSegmentPlusIteratorByInterval(ResultIterator<DataSegmentPlus> resultIterator, Collection<Interval> intervals, IntervalMode matchMode) {
        return Iterators.filter(resultIterator, dataSegment -> {
            if (dataSegment == null) {
                return false;
            }
            if (intervals.isEmpty()) {
                return true;
            }
            for (Interval interval : intervals) {
                if (!matchMode.apply(interval, dataSegment.getDataSegment().getInterval())) continue;
                return true;
            }
            return false;
        });
    }

    private static int computeNumChangedSegments(List<String> segmentIds, int[] segmentChanges) {
        int numChangedSegments = 0;
        for (int i = 0; i < segmentChanges.length; ++i) {
            int numUpdatedRows = segmentChanges[i];
            if (numUpdatedRows < 0) {
                log.error("ASSERTION_ERROR: Negative number of rows updated for segment id [%s]: %d", new Object[]{segmentIds.get(i), numUpdatedRows});
            } else if (numUpdatedRows > 1) {
                log.error("More than one row updated for segment id [%s]: %d, there may be more than one row for the segment id in the database", new Object[]{segmentIds.get(i), numUpdatedRows});
            }
            if (numUpdatedRows <= 0) continue;
            ++numChangedSegments;
        }
        return numChangedSegments;
    }

    public static String getParameterizedInConditionForColumn(String columnName, List<String> values) {
        if (values == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.format((String)" AND %s IN (", (Object[])new Object[]{columnName}));
        for (int i = 0; i < values.size(); ++i) {
            sb.append(StringUtils.format((String)":%s%d", (Object[])new Object[]{columnName, i}));
            if (i == values.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static void bindColumnValuesToQueryWithInCondition(String columnName, List<String> values, SQLStatement<?> query) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            query.bind(StringUtils.format((String)"%s%d", (Object[])new Object[]{columnName, i}), values.get(i));
        }
    }

    static enum IntervalMode {
        CONTAINS{

            @Override
            public String makeSqlCondition(String quoteString, String startPlaceholder, String endPlaceholder) {
                return StringUtils.format((String)"(start >= %2$s and start <= %3$s and %1$send%1$s <= %3$s)", (Object[])new Object[]{quoteString, startPlaceholder, endPlaceholder});
            }

            @Override
            public boolean apply(Interval a, Interval b) {
                return a.contains((ReadableInterval)b);
            }
        }
        ,
        OVERLAPS{

            @Override
            public String makeSqlCondition(String quoteString, String startPlaceholder, String endPlaceholder) {
                return StringUtils.format((String)"(start < %3$s AND %1$send%1$s > %2$s)", (Object[])new Object[]{quoteString, startPlaceholder, endPlaceholder});
            }

            @Override
            public boolean apply(Interval a, Interval b) {
                return a.overlaps((ReadableInterval)b);
            }
        };


        public abstract String makeSqlCondition(String var1, String var2, String var3);

        public abstract boolean apply(Interval var1, Interval var2);
    }
}

