/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientCompactionRunnerInfo;
import org.apache.druid.client.indexing.ClientCompactionTaskDimensionsSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.transform.CompactionTransformSpec;

public class ClientCompactionTaskQuery
implements ClientTaskQuery {
    public static final String TYPE = "compact";
    private final String id;
    private final String dataSource;
    private final ClientCompactionIOConfig ioConfig;
    private final ClientCompactionTaskQueryTuningConfig tuningConfig;
    private final ClientCompactionTaskGranularitySpec granularitySpec;
    private final ClientCompactionTaskDimensionsSpec dimensionsSpec;
    private final AggregatorFactory[] metricsSpec;
    private final CompactionTransformSpec transformSpec;
    @Nullable
    private final List<AggregateProjectionSpec> projections;
    private final Map<String, Object> context;
    private final ClientCompactionRunnerInfo compactionRunner;

    @JsonCreator
    public ClientCompactionTaskQuery(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="ioConfig") ClientCompactionIOConfig ioConfig, @JsonProperty(value="tuningConfig") ClientCompactionTaskQueryTuningConfig tuningConfig, @JsonProperty(value="granularitySpec") ClientCompactionTaskGranularitySpec granularitySpec, @JsonProperty(value="dimensionsSpec") ClientCompactionTaskDimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") AggregatorFactory[] metrics, @JsonProperty(value="transformSpec") CompactionTransformSpec transformSpec, @JsonProperty(value="projections") @Nullable List<AggregateProjectionSpec> projections, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="compactionRunner") @Nullable ClientCompactionRunnerInfo compactionRunner) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.dataSource = dataSource;
        this.ioConfig = ioConfig;
        this.tuningConfig = tuningConfig;
        this.granularitySpec = granularitySpec;
        this.dimensionsSpec = dimensionsSpec;
        this.metricsSpec = metrics;
        this.transformSpec = transformSpec;
        this.projections = projections;
        this.context = context;
        this.compactionRunner = compactionRunner;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public ClientCompactionIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @JsonProperty
    public ClientCompactionTaskQueryTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty
    public ClientCompactionTaskGranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    public ClientCompactionTaskDimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty
    @Nullable
    public AggregatorFactory[] getMetricsSpec() {
        return this.metricsSpec;
    }

    @JsonProperty
    public CompactionTransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    @JsonProperty(value="projections")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public List<AggregateProjectionSpec> getProjections() {
        return this.projections;
    }

    @JsonProperty(value="compactionRunner")
    @Nullable
    public ClientCompactionRunnerInfo getCompactionRunner() {
        return this.compactionRunner;
    }

    public boolean isMsq() {
        return this.compactionRunner != null && this.compactionRunner.getType() == CompactionEngine.MSQ;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCompactionTaskQuery that = (ClientCompactionTaskQuery)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.ioConfig, that.ioConfig) && Objects.equals(this.tuningConfig, that.tuningConfig) && Objects.equals(this.granularitySpec, that.granularitySpec) && Objects.equals(this.dimensionsSpec, that.dimensionsSpec) && Arrays.equals(this.metricsSpec, that.metricsSpec) && Objects.equals(this.transformSpec, that.transformSpec) && Objects.equals(this.projections, that.projections) && Objects.equals(this.context, that.context) && Objects.equals(this.compactionRunner, that.compactionRunner);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.dataSource, this.ioConfig, this.tuningConfig, this.granularitySpec, this.dimensionsSpec, this.transformSpec, this.projections, this.context, this.compactionRunner);
        result = 31 * result + Arrays.hashCode(this.metricsSpec);
        return result;
    }

    public String toString() {
        return "ClientCompactionTaskQuery{id='" + this.id + "', dataSource='" + this.dataSource + "', ioConfig=" + String.valueOf(this.ioConfig) + ", tuningConfig=" + String.valueOf(this.tuningConfig) + ", granularitySpec=" + String.valueOf(this.granularitySpec) + ", dimensionsSpec=" + String.valueOf(this.dimensionsSpec) + ", metricsSpec=" + Arrays.toString(this.metricsSpec) + ", transformSpec=" + String.valueOf(this.transformSpec) + ", catalogConfig=" + String.valueOf(this.projections) + ", context=" + String.valueOf(this.context) + ", compactionRunner=" + String.valueOf(this.compactionRunner) + "}";
    }
}

