/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.model.table.DatasourceDefn;
import org.apache.druid.catalog.model.table.ExternalTableDefn;
import org.apache.druid.catalog.model.table.HttpInputSourceDefn;
import org.apache.druid.catalog.model.table.InlineInputSourceDefn;
import org.apache.druid.catalog.model.table.InputFormatDefn;
import org.apache.druid.catalog.model.table.InputFormats;
import org.apache.druid.catalog.model.table.InputSourceDefn;
import org.apache.druid.catalog.model.table.LocalInputSourceDefn;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.IAE;

public class TableDefnRegistry {
    private static final List<TableDefn> BUILTIN_TABLE_DEFNS = Arrays.asList(new DatasourceDefn(), new ExternalTableDefn());
    private static final List<InputSourceDefn> BUILTIN_INPUT_SOURCE_DEFNS = Arrays.asList(new InlineInputSourceDefn(), new HttpInputSourceDefn(), new LocalInputSourceDefn());
    private static final List<InputFormatDefn> BUILTIN_INPUT_FORMAT_DEFNS = Arrays.asList(new InputFormats.CsvFormatDefn(), new InputFormats.DelimitedFormatDefn(), new InputFormats.JsonFormatDefn());
    private final Map<String, TableDefn> tableDefns;
    private final Map<String, InputSourceDefn> inputSourceDefns;
    private final Map<String, InputFormatDefn> inputFormatDefns;
    private final ObjectMapper jsonMapper;

    public TableDefnRegistry(@Nullable List<TableDefn> tableDefnExtns, @Nullable List<InputSourceDefn> inputSourceDefnExtns, @Nullable List<InputFormatDefn> inputFormatDefnExtns, ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        List<TableDefn> tableDefns = CatalogUtils.concatLists(tableDefnExtns, BUILTIN_TABLE_DEFNS);
        List<InputSourceDefn> inputSourceDefns = CatalogUtils.concatLists(inputSourceDefnExtns, BUILTIN_INPUT_SOURCE_DEFNS);
        List<InputFormatDefn> inputFormatDefns = CatalogUtils.concatLists(inputFormatDefnExtns, BUILTIN_INPUT_FORMAT_DEFNS);
        ImmutableMap.Builder tableBuilder = ImmutableMap.builder();
        for (TableDefn tableDefn : tableDefns) {
            tableBuilder.put((Object)tableDefn.typeValue(), (Object)tableDefn);
        }
        this.tableDefns = tableBuilder.build();
        ImmutableMap.Builder sourceBuilder = ImmutableMap.builder();
        for (InputSourceDefn defn : inputSourceDefns) {
            sourceBuilder.put((Object)defn.typeValue(), (Object)defn);
        }
        this.inputSourceDefns = sourceBuilder.build();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (InputFormatDefn inputFormatDefn : inputFormatDefns) {
            builder.put((Object)inputFormatDefn.typeValue(), (Object)inputFormatDefn);
        }
        this.inputFormatDefns = builder.build();
        for (InputSourceDefn inputSourceDefn : inputSourceDefns) {
            inputSourceDefn.bind(this);
        }
        for (TableDefn tableDefn : tableDefns) {
            tableDefn.bind(this);
        }
    }

    @Inject
    public TableDefnRegistry(@Json ObjectMapper jsonMapper) {
        this(null, null, null, jsonMapper);
    }

    public TableDefn tableDefnFor(String type) {
        return this.tableDefns.get(type);
    }

    public ObjectMapper jsonMapper() {
        return this.jsonMapper;
    }

    public ResolvedTable resolve(TableSpec spec) {
        String type = spec.type();
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IAE("The table type is required.", new Object[0]);
        }
        TableDefn defn = this.tableDefns.get(type);
        if (defn == null) {
            throw new IAE("Table type [%s] is not valid.", new Object[]{type});
        }
        return new ResolvedTable(defn, spec, this.jsonMapper);
    }

    public InputSourceDefn inputSourceDefnFor(String type) {
        return this.inputSourceDefns.get(type);
    }

    public InputFormatDefn inputFormatDefnFor(String type) {
        return this.inputFormatDefns.get(type);
    }

    public Map<String, InputFormatDefn> formats() {
        return this.inputFormatDefns;
    }
}

