/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.transform.TransformSpec;

public class DataSchema {
    private static final Logger log = new Logger(DataSchema.class);
    private final String dataSource;
    private final AggregatorFactory[] aggregators;
    private final GranularitySpec granularitySpec;
    private final TransformSpec transformSpec;
    private final Map<String, Object> parserMap;
    private final ObjectMapper objectMapper;
    private TimestampSpec timestampSpec;
    private DimensionsSpec dimensionsSpec;
    private InputRowParser inputRowParser;
    @Nullable
    private List<AggregateProjectionSpec> projections;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataSchema schema) {
        return new Builder(schema);
    }

    @JsonCreator
    public DataSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="timestampSpec") @Nullable TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") @Nullable DimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") AggregatorFactory[] aggregators, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="transformSpec") TransformSpec transformSpec, @JsonProperty(value="projections") @Nullable List<AggregateProjectionSpec> projections, @Deprecated @JsonProperty(value="parser") @Nullable Map<String, Object> parserMap, @JacksonInject ObjectMapper objectMapper) {
        DataSchema.validateDatasourceName(dataSource);
        this.dataSource = dataSource;
        this.timestampSpec = timestampSpec;
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
        DimensionsSpec dimensionsSpec2 = this.dimensionsSpec = dimensionsSpec == null ? null : DataSchema.computeDimensionsSpec((TimestampSpec)Preconditions.checkNotNull((Object)timestampSpec, (Object)"timestampSpec"), dimensionsSpec, this.aggregators);
        if (granularitySpec == null) {
            log.warn("No granularitySpec has been specified. Using UniformGranularitySpec as default.", new Object[0]);
            this.granularitySpec = new UniformGranularitySpec(null, null, null);
        } else {
            this.granularitySpec = granularitySpec;
        }
        this.transformSpec = transformSpec == null ? TransformSpec.NONE : transformSpec;
        this.projections = projections;
        this.parserMap = parserMap;
        this.objectMapper = objectMapper;
        DataSchema.computeAndValidateOutputFieldNames(this.dimensionsSpec, this.aggregators);
        DataSchema.validateProjections(this.projections, this.granularitySpec instanceof UniformGranularitySpec ? this.granularitySpec.getSegmentGranularity() : null);
        if (this.granularitySpec.isRollup() && this.aggregators.length == 0) {
            log.warn("Rollup is enabled for dataSource [%s] but no metricsSpec has been provided. Are you sure this is what you want?", new Object[]{dataSource});
        }
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Nullable
    @JsonProperty(value="timestampSpec")
    private TimestampSpec getGivenTimestampSpec() {
        return this.timestampSpec;
    }

    public TimestampSpec getTimestampSpec() {
        if (this.timestampSpec == null) {
            this.timestampSpec = ((InputRowParser)Preconditions.checkNotNull((Object)this.getParser(), (Object)"inputRowParser")).getParseSpec().getTimestampSpec();
        }
        return this.timestampSpec;
    }

    @Nullable
    @JsonProperty(value="dimensionsSpec")
    private DimensionsSpec getGivenDimensionsSpec() {
        return this.dimensionsSpec;
    }

    public DimensionsSpec getDimensionsSpec() {
        if (this.dimensionsSpec == null) {
            this.dimensionsSpec = DataSchema.computeDimensionsSpec(this.getTimestampSpec(), ((InputRowParser)Preconditions.checkNotNull((Object)this.getParser(), (Object)"inputRowParser")).getParseSpec().getDimensionsSpec(), this.aggregators);
        }
        return this.dimensionsSpec;
    }

    @JsonProperty(value="metricsSpec")
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    public TransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public List<AggregateProjectionSpec> getProjections() {
        return this.projections;
    }

    @Nullable
    public List<String> getProjectionNames() {
        if (this.projections == null) {
            return null;
        }
        return this.projections.stream().map(AggregateProjectionSpec::getName).collect(Collectors.toList());
    }

    @Deprecated
    @JsonProperty(value="parser")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getParserMap() {
        return this.parserMap;
    }

    @Nullable
    public InputRowParser getParser() {
        if (this.inputRowParser == null) {
            if (this.parserMap == null) {
                return null;
            }
            this.inputRowParser = this.transformSpec.decorate((InputRowParser)this.objectMapper.convertValue(this.parserMap, InputRowParser.class));
            ParseSpec parseSpec = this.inputRowParser.getParseSpec();
            parseSpec = parseSpec.withDimensionsSpec(DataSchema.computeDimensionsSpec(parseSpec.getTimestampSpec(), parseSpec.getDimensionsSpec(), this.aggregators));
            if (this.timestampSpec != null) {
                parseSpec = parseSpec.withTimestampSpec(this.timestampSpec);
            }
            if (this.dimensionsSpec != null) {
                parseSpec = parseSpec.withDimensionsSpec(this.dimensionsSpec);
            }
            this.inputRowParser = this.inputRowParser.withParseSpec(parseSpec);
        }
        return this.inputRowParser;
    }

    public DataSchema withGranularitySpec(GranularitySpec granularitySpec) {
        return DataSchema.builder(this).withGranularity(granularitySpec).build();
    }

    public DataSchema withTransformSpec(TransformSpec transformSpec) {
        return DataSchema.builder(this).withTransform(transformSpec).build();
    }

    public DataSchema withDimensionsSpec(DimensionsSpec dimensionsSpec) {
        return DataSchema.builder(this).withDimensions(dimensionsSpec).build();
    }

    public String toString() {
        return "DataSchema{dataSource='" + this.dataSource + "', aggregators=" + Arrays.toString(this.aggregators) + ", granularitySpec=" + String.valueOf(this.granularitySpec) + ", transformSpec=" + String.valueOf(this.transformSpec) + ", parserMap=" + String.valueOf(this.parserMap) + ", timestampSpec=" + String.valueOf(this.timestampSpec) + ", dimensionsSpec=" + String.valueOf(this.dimensionsSpec) + ", projections=" + String.valueOf(this.projections) + ", inputRowParser=" + String.valueOf(this.inputRowParser) + "}";
    }

    private static void validateDatasourceName(String dataSource) {
        IdUtils.validateId((String)"dataSource", (String)dataSource);
    }

    private static DimensionsSpec computeDimensionsSpec(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, AggregatorFactory[] aggregators) {
        Set<String> inputFieldNames = DataSchema.computeInputFieldNames(timestampSpec, dimensionsSpec, aggregators);
        Set<String> outputFieldNames = DataSchema.computeAndValidateOutputFieldNames(dimensionsSpec, aggregators);
        HashSet<String> additionalDimensionExclusions = new HashSet<String>();
        additionalDimensionExclusions.addAll(inputFieldNames);
        additionalDimensionExclusions.addAll(outputFieldNames);
        additionalDimensionExclusions.removeAll(dimensionsSpec.getDimensionNames());
        return dimensionsSpec.withDimensionExclusions(additionalDimensionExclusions);
    }

    private static Set<String> computeInputFieldNames(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, AggregatorFactory[] aggregators) {
        HashSet<String> fields = new HashSet<String>();
        fields.add(timestampSpec.getTimestampColumn());
        fields.addAll(dimensionsSpec.getDimensionNames());
        Arrays.stream(aggregators).flatMap(aggregator -> aggregator.requiredFields().stream()).forEach(fields::add);
        return fields;
    }

    private static Set<String> computeAndValidateOutputFieldNames(@Nullable DimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] aggregators) {
        TreeMap<String, Multiset<String>> fields = new TreeMap<String, Multiset<String>>();
        fields.computeIfAbsent("__time", k -> TreeMultiset.create()).add((Object)StringUtils.format((String)"primary timestamp (%s cannot appear elsewhere except as long-typed dimension)", (Object[])new Object[]{"__time"}));
        if (dimensionsSpec != null) {
            boolean sawTimeDimension = false;
            for (int i = 0; i < dimensionsSpec.getDimensions().size(); ++i) {
                DimensionSchema dimSchema = (DimensionSchema)dimensionsSpec.getDimensions().get(i);
                String field = dimSchema.getName();
                if (Strings.isNullOrEmpty((String)field)) {
                    throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Encountered dimension with null or empty name at position[%d]", new Object[]{i});
                }
                if ("__time".equals(field)) {
                    if (i > 0 && dimensionsSpec.isForceSegmentSortByTime()) {
                        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Encountered dimension[%s] at position[%d]. This is only supported when the dimensionsSpec parameter[%s] is set to[false]. %s", new Object[]{field, i, "forceSegmentSortByTime", DimensionsSpec.WARNING_NON_TIME_SORT_ORDER});
                    }
                    if (!dimSchema.getColumnType().is((TypeDescriptor)ValueType.LONG)) {
                        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Encountered dimension[%s] with incorrect type[%s]. Type must be 'long'.", new Object[]{field, dimSchema.getColumnType()});
                    }
                    if (!sawTimeDimension) {
                        sawTimeDimension = true;
                        continue;
                    }
                }
                fields.computeIfAbsent(field, k -> TreeMultiset.create()).add((Object)"dimensions list");
            }
        }
        if (aggregators != null) {
            for (int i = 0; i < aggregators.length; ++i) {
                String field = aggregators[i].getName();
                if (Strings.isNullOrEmpty((String)field)) {
                    throw new IAE("Encountered metric with null or empty name at position %d", new Object[]{i});
                }
                fields.computeIfAbsent(field, k -> TreeMultiset.create()).add((Object)"metricsSpec list");
            }
        }
        return DataSchema.getFieldsOrThrowIfErrors(fields);
    }

    public static void validateProjections(@Nullable List<AggregateProjectionSpec> projections, @Nullable Granularity segmentGranularity) {
        if (projections != null) {
            HashSet names = Sets.newHashSetWithExpectedSize((int)projections.size());
            for (AggregateProjectionSpec projection : projections) {
                if (names.contains(projection.getName())) {
                    throw InvalidInput.exception((String)"projection[%s] is already defined, projection names must be unique", (Object[])new Object[]{projection.getName()});
                }
                names.add(projection.getName());
                AggregateProjectionMetadata.Schema schema = projection.toMetadataSchema();
                if (schema.getTimeColumnName() != null) {
                    Granularity projectionGranularity = schema.getEffectiveGranularity();
                    if (segmentGranularity != null && segmentGranularity.isFinerThan(projectionGranularity)) {
                        throw InvalidInput.exception((String)"projection[%s] has granularity[%s] which must be finer than or equal to segment granularity[%s]", (Object[])new Object[]{projection.getName(), projectionGranularity, segmentGranularity});
                    }
                }
                TreeMap<String, Multiset<String>> fields = new TreeMap<String, Multiset<String>>();
                int position = 0;
                for (DimensionSchema grouping : projection.getGroupingColumns()) {
                    String field = grouping.getName();
                    if (Strings.isNullOrEmpty((String)field)) {
                        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Encountered grouping column with null or empty name at position[%d]", new Object[]{position});
                    }
                    fields.computeIfAbsent(field, k -> TreeMultiset.create()).add((Object)("projection[" + projection.getName() + "] grouping column list"));
                    ++position;
                }
                for (AggregatorFactory aggregator : projection.getAggregators()) {
                    String field = aggregator.getName();
                    if (Strings.isNullOrEmpty((String)field)) {
                        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Encountered aggregator with null or empty name at position[%d]", new Object[]{position});
                    }
                    fields.computeIfAbsent(field, k -> TreeMultiset.create()).add((Object)("projection[" + projection.getName() + "] aggregators list"));
                    ++position;
                }
                DataSchema.getFieldsOrThrowIfErrors(fields);
            }
        }
    }

    private static Set<String> getFieldsOrThrowIfErrors(Map<String, Multiset<String>> validatedFields) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry<String, Multiset<String>> fieldEntry : validatedFields.entrySet()) {
            if (fieldEntry.getValue().entrySet().stream().mapToInt(Multiset.Entry::getCount).sum() <= 1) continue;
            errors.add(StringUtils.format((String)"[%s] seen in %s", (Object[])new Object[]{fieldEntry.getKey(), fieldEntry.getValue().entrySet().stream().map(entry -> StringUtils.format((String)"%s%s", (Object[])new Object[]{entry.getElement(), entry.getCount() == 1 ? "" : StringUtils.format((String)" (%d occurrences)", (Object[])new Object[]{entry.getCount()})})).collect(Collectors.joining(", "))}));
        }
        if (errors.isEmpty()) {
            return validatedFields.keySet();
        }
        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build("Cannot specify a column more than once: %s", new Object[]{String.join((CharSequence)"; ", errors)});
    }

    public static class Builder {
        private String dataSource;
        private AggregatorFactory[] aggregators;
        private GranularitySpec granularitySpec;
        private TransformSpec transformSpec;
        private Map<String, Object> parserMap;
        private ObjectMapper objectMapper;
        private TimestampSpec timestampSpec;
        private DimensionsSpec dimensionsSpec;
        private List<AggregateProjectionSpec> projections;

        public Builder() {
        }

        public Builder(DataSchema schema) {
            this.dataSource = schema.dataSource;
            this.timestampSpec = schema.timestampSpec;
            this.dimensionsSpec = schema.dimensionsSpec;
            this.transformSpec = schema.transformSpec;
            this.aggregators = schema.aggregators;
            this.projections = schema.projections;
            this.granularitySpec = schema.granularitySpec;
            this.parserMap = schema.parserMap;
            this.objectMapper = schema.objectMapper;
        }

        public Builder withDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder withTimestamp(TimestampSpec timestampSpec) {
            this.timestampSpec = timestampSpec;
            return this;
        }

        public Builder withDimensions(DimensionsSpec dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec;
            return this;
        }

        public Builder withDimensions(List<DimensionSchema> dimensions) {
            this.dimensionsSpec = DimensionsSpec.builder().setDimensions(dimensions).build();
            return this;
        }

        public Builder withDimensions(DimensionSchema ... dimensions) {
            return this.withDimensions(Arrays.asList(dimensions));
        }

        public Builder withAggregators(AggregatorFactory ... aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public Builder withGranularity(GranularitySpec granularitySpec) {
            this.granularitySpec = granularitySpec;
            return this;
        }

        public Builder withTransform(TransformSpec transformSpec) {
            this.transformSpec = transformSpec;
            return this;
        }

        public Builder withProjections(List<AggregateProjectionSpec> projections) {
            this.projections = projections;
            return this;
        }

        @Deprecated
        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Deprecated
        public Builder withParserMap(Map<String, Object> parserMap) {
            this.parserMap = parserMap;
            return this;
        }

        public DataSchema build() {
            return new DataSchema(this.dataSource, this.timestampSpec, this.dimensionsSpec, this.aggregators, this.granularitySpec, this.transformSpec, this.projections, this.parserMap, this.objectMapper);
        }
    }
}

