/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.util.List;
import java.util.Properties;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.security.DefaultTLSCertificateCheckerModule;
import org.apache.druid.server.security.TLSCertificateChecker;

public class TLSCertificateCheckerModule
implements Module {
    private static final String CHECKER_TYPE_PROPERTY = "druid.tls.certificateChecker";
    private Properties props;

    @Inject
    public void setProps(Properties props) {
        this.props = props;
    }

    public void configure(Binder binder) {
        String checkerType = this.props.getProperty(CHECKER_TYPE_PROPERTY, "default");
        binder.install((Module)new DefaultTLSCertificateCheckerModule());
        binder.bind(TLSCertificateChecker.class).toProvider((Provider)new TLSCertificateCheckerProvider(checkerType)).in(LazySingleton.class);
    }

    public static class TLSCertificateCheckerProvider
    implements Provider<TLSCertificateChecker> {
        private final String checkerType;
        private TLSCertificateChecker checker = null;

        public TLSCertificateCheckerProvider(String checkerType) {
            this.checkerType = checkerType;
        }

        @Inject
        public void inject(Injector injector) {
            List checkerBindings = injector.findBindingsByType((TypeLiteral)new TypeLiteral<TLSCertificateChecker>(){});
            this.checker = this.findChecker(this.checkerType, checkerBindings);
            if (this.checker == null) {
                throw new IAE("Could not find certificate checker with type: " + this.checkerType, new Object[0]);
            }
        }

        public TLSCertificateChecker get() {
            if (this.checker == null) {
                throw new ISE("Checker was null, that's bad!", new Object[0]);
            }
            return this.checker;
        }

        private TLSCertificateChecker findChecker(String checkerType, List<Binding<TLSCertificateChecker>> checkerBindings) {
            for (Binding<TLSCertificateChecker> binding : checkerBindings) {
                if (!Names.named((String)checkerType).equals(binding.getKey().getAnnotation())) continue;
                return (TLSCertificateChecker)binding.getProvider().get();
            }
            return null;
        }
    }
}

