/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Scope;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.guice.DruidScopes;
import org.apache.druid.guice.annotations.JSR311Resource;

public class DruidGuiceContainer
extends GuiceContainer {
    private final Set<Class<?>> resources;
    private final Injector injector;
    private WebApplication webapp;

    @Nonnull
    public static Map<Scope, ComponentScope> populateScopeMap(Map<Scope, ComponentScope> map) {
        map.put(DruidScopes.SINGLETON, ComponentScope.Singleton);
        return map;
    }

    @Inject
    public DruidGuiceContainer(Injector injector, @JSR311Resource Set<Class<?>> resources) {
        super(injector);
        this.injector = injector;
        this.resources = resources;
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) {
        return new DefaultResourceConfig(this.resources);
    }

    protected void initiate(ResourceConfig config, WebApplication webapp) {
        this.webapp = webapp;
        webapp.initiate(config, (IoCComponentProviderFactory)new GuiceContainer.ServletGuiceComponentProviderFactory(config, this.injector){

            public Map<Scope, ComponentScope> createScopeMap() {
                return DruidGuiceContainer.populateScopeMap(super.createScopeMap());
            }
        });
    }

    public WebApplication getWebApplication() {
        return this.webapp;
    }
}

