/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.loading.CacheEntry;
import org.apache.druid.segment.loading.CacheEntryIdentifier;

@ThreadSafe
public class StorageLocation {
    private static final EmittingLogger log = new EmittingLogger(StorageLocation.class);
    private final File path;
    private final long maxSizeBytes;
    private final long freeSpaceToKeep;
    @GuardedBy(value="lock")
    private final Map<CacheEntryIdentifier, CacheEntry> staticCacheEntries = new HashMap<CacheEntryIdentifier, CacheEntry>();
    @GuardedBy(value="lock")
    private final Map<CacheEntryIdentifier, WeakCacheEntry> weakCacheEntries = new HashMap<CacheEntryIdentifier, WeakCacheEntry>();
    @GuardedBy(value="lock")
    private WeakCacheEntry head;
    @GuardedBy(value="lock")
    private WeakCacheEntry tail;
    @GuardedBy(value="lock")
    private WeakCacheEntry hand;
    private final AtomicLong currSizeBytes = new AtomicLong(0L);
    private final AtomicLong currWeakSizeBytes = new AtomicLong(0L);
    private final AtomicReference<Stats> stats = new AtomicReference();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    public StorageLocation(File path, long maxSizeBytes, @Nullable Double freeSpacePercent) {
        this.path = path;
        this.maxSizeBytes = maxSizeBytes;
        if (freeSpacePercent != null) {
            long totalSpaceInPartition = path.getTotalSpace();
            this.freeSpaceToKeep = (long)(freeSpacePercent * (double)totalSpaceInPartition / 100.0);
            log.info("SegmentLocation[%s] will try and maintain [%d:%d] free space while loading segments.", new Object[]{path, this.freeSpaceToKeep, totalSpaceInPartition});
        } else {
            this.freeSpaceToKeep = 0L;
        }
        this.resetStats();
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public File getPath() {
        return this.path;
    }

    public <T extends CacheEntry> T getStaticCacheEntry(CacheEntryIdentifier entryId) {
        this.lock.readLock().lock();
        try {
            if (this.staticCacheEntries.containsKey(entryId)) {
                CacheEntry cacheEntry = this.staticCacheEntries.get(entryId);
                return (T)cacheEntry;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends CacheEntry> T getCacheEntry(CacheEntryIdentifier entryId) {
        this.lock.readLock().lock();
        try {
            if (this.staticCacheEntries.containsKey(entryId)) {
                CacheEntry cacheEntry = this.staticCacheEntries.get(entryId);
                return (T)cacheEntry;
            }
            if (this.weakCacheEntries.containsKey(entryId)) {
                WeakCacheEntry weakCacheEntry = this.weakCacheEntries.get(entryId);
                weakCacheEntry.visited = true;
                CacheEntry cacheEntry = weakCacheEntry.cacheEntry;
                return (T)cacheEntry;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isReserved(CacheEntryIdentifier identifier) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.staticCacheEntries.containsKey(identifier);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isWeakReserved(CacheEntryIdentifier identifier) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.weakCacheEntries.containsKey(identifier);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserve(CacheEntry entry) {
        this.lock.readLock().lock();
        try {
            if (this.staticCacheEntries.containsKey(entry.getId())) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            ReclaimResult reclaimResult = this.canHandle(entry);
            this.unmountReclaimed(reclaimResult);
            if (reclaimResult.isSuccess()) {
                this.staticCacheEntries.put(entry.getId(), entry);
                this.currSizeBytes.getAndAdd(entry.getSize());
            }
            boolean bl = reclaimResult.isSuccess();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserveWeak(CacheEntry entry) {
        this.lock.readLock().lock();
        try {
            if (this.staticCacheEntries.containsKey(entry.getId())) {
                boolean bl = true;
                return bl;
            }
            if (this.weakCacheEntries.containsKey(entry.getId())) {
                this.weakCacheEntries.get((Object)entry.getId()).visited = true;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.staticCacheEntries.containsKey(entry.getId())) {
                boolean bl = true;
                return bl;
            }
            if (this.weakCacheEntries.containsKey(entry.getId())) {
                this.weakCacheEntries.get((Object)entry.getId()).visited = true;
                boolean bl = true;
                return bl;
            }
            ReclaimResult reclaimResult = this.canHandleWeak(entry);
            this.unmountReclaimed(reclaimResult);
            if (reclaimResult.isSuccess()) {
                WeakCacheEntry newEntry = new WeakCacheEntry(entry);
                this.linkNewWeakEntry(newEntry);
                this.weakCacheEntries.put(entry.getId(), newEntry);
                this.stats.get().load();
            }
            boolean bl = reclaimResult.isSuccess();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends CacheEntry> ReservationHold<T> addWeakReservationHoldIfExists(CacheEntryIdentifier entryId) {
        this.lock.readLock().lock();
        try {
            if (this.staticCacheEntries.containsKey(entryId)) {
                ReservationHold<CacheEntry> reservationHold = new ReservationHold<CacheEntry>(this.staticCacheEntries.get(entryId), () -> {});
                return reservationHold;
            }
            WeakCacheEntry existingEntry = this.weakCacheEntries.get(entryId);
            if (existingEntry != null && existingEntry.hold()) {
                existingEntry.visited = true;
                this.stats.get().hit();
                ReservationHold<CacheEntry> reservationHold = new ReservationHold<CacheEntry>(existingEntry.cacheEntry, () -> existingEntry.release());
                return reservationHold;
            }
            ReservationHold<T> reservationHold = null;
            return reservationHold;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends CacheEntry> ReservationHold<T> addWeakReservationHold(CacheEntryIdentifier entryId, Supplier<? extends CacheEntry> entrySupplier) {
        ReservationHold<T> existingEntry = this.addWeakReservationHoldIfExists(entryId);
        if (existingEntry != null) {
            return existingEntry;
        }
        this.lock.writeLock().lock();
        try {
            ReservationHold<CacheEntry> hold;
            WeakCacheEntry retryExistingEntry = this.weakCacheEntries.get(entryId);
            if (retryExistingEntry != null && retryExistingEntry.hold()) {
                retryExistingEntry.visited = true;
                this.stats.get().hit();
                ReservationHold<CacheEntry> reservationHold = new ReservationHold<CacheEntry>(retryExistingEntry.cacheEntry, () -> retryExistingEntry.release());
                return reservationHold;
            }
            CacheEntry newEntry = entrySupplier.get();
            ReclaimResult reclaimResult = this.canHandleWeak(newEntry);
            this.unmountReclaimed(reclaimResult);
            if (reclaimResult.isSuccess()) {
                WeakCacheEntry newWeakEntry = new WeakCacheEntry(newEntry);
                newWeakEntry.hold();
                this.linkNewWeakEntry(newWeakEntry);
                this.weakCacheEntries.put(newEntry.getId(), newWeakEntry);
                this.stats.get().load();
                hold = new ReservationHold<CacheEntry>(newEntry, () -> {
                    newWeakEntry.release();
                    this.lock.writeLock().lock();
                    try {
                        this.weakCacheEntries.computeIfPresent(newEntry.getId(), (cacheEntryIdentifier, weakCacheEntry) -> {
                            if (!weakCacheEntry.cacheEntry.isMounted()) {
                                this.unlinkWeakEntry((WeakCacheEntry)weakCacheEntry);
                                weakCacheEntry.unmount();
                                return null;
                            }
                            return weakCacheEntry;
                        });
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                });
            } else {
                this.stats.get().reject();
                hold = null;
            }
            ReservationHold<CacheEntry> reservationHold = hold;
            return reservationHold;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void release(CacheEntry entry) {
        this.lock.writeLock().lock();
        try {
            if (this.staticCacheEntries.containsKey(entry.getId())) {
                CacheEntry toRemove = this.staticCacheEntries.remove(entry.getId());
                toRemove.unmount();
                this.currSizeBytes.getAndAdd(-entry.getSize());
            } else if (this.weakCacheEntries.containsKey(entry.getId())) {
                WeakCacheEntry toRemove = this.weakCacheEntries.remove(entry.getId());
                this.unlinkWeakEntry(toRemove);
                toRemove.unmount();
                this.stats.get().unmount();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @GuardedBy(value="lock")
    private void linkNewWeakEntry(WeakCacheEntry newWeakEntry) {
        if (this.head != null) {
            newWeakEntry.next = this.head;
            this.head.prev = newWeakEntry;
        } else {
            this.tail = newWeakEntry;
            this.hand = newWeakEntry;
        }
        this.head = newWeakEntry;
        this.currWeakSizeBytes.getAndAdd(newWeakEntry.cacheEntry.getSize());
        this.currSizeBytes.getAndAdd(newWeakEntry.cacheEntry.getSize());
    }

    @GuardedBy(value="lock")
    private void unlinkWeakEntry(WeakCacheEntry toRemove) {
        if (this.head == toRemove) {
            this.head = toRemove.next;
        }
        if (this.tail == toRemove) {
            this.tail = toRemove.prev;
        }
        if (this.hand == toRemove) {
            WeakCacheEntry weakCacheEntry = this.hand = toRemove.prev != null ? toRemove.prev : this.tail;
        }
        if (toRemove.prev != null) {
            toRemove.prev.next = toRemove.next;
        }
        if (toRemove.next != null) {
            toRemove.next.prev = toRemove.prev;
        }
        toRemove.prev = null;
        toRemove.next = null;
        this.currSizeBytes.getAndAdd(-toRemove.cacheEntry.getSize());
        this.currWeakSizeBytes.getAndAdd(-toRemove.cacheEntry.getSize());
    }

    @VisibleForTesting
    @GuardedBy(value="lock")
    ReclaimResult canHandle(CacheEntry entry) {
        return this.canHandle(entry, false);
    }

    @GuardedBy(value="lock")
    private ReclaimResult canHandleWeak(CacheEntry entry) {
        return this.canHandle(entry, true);
    }

    @GuardedBy(value="lock")
    private ReclaimResult canHandle(CacheEntry entry, boolean weak) {
        ReclaimResult result;
        ArrayList<WeakCacheEntry> evicted = new ArrayList<WeakCacheEntry>();
        long bytesReclaimed = 0L;
        if (this.availableSizeBytes() < entry.getSize()) {
            long sizeToReclaim = entry.getSize() - this.availableSizeBytes();
            result = this.reclaim(sizeToReclaim);
            if (!result.isSuccess()) {
                String msg = StringUtils.format((String)"Cache entry[%s:%,d] too large for storage[%s:%,d/%,d]", (Object[])new Object[]{entry.getId(), entry.getSize(), this.getPath(), this.availableSizeBytes(), this.maxSizeBytes});
                if (weak) {
                    log.debug(msg, new Object[0]);
                } else {
                    log.warn(msg, new Object[0]);
                }
                return ReclaimResult.failed(sizeToReclaim);
            }
            bytesReclaimed += result.bytesReclaimed;
            evicted.addAll(result.getEvictions());
        }
        if (this.freeSpaceToKeep > 0L) {
            long currFreeSpace = this.path.getFreeSpace();
            if (this.freeSpaceToKeep + entry.getSize() > currFreeSpace) {
                result = this.reclaim(this.freeSpaceToKeep + entry.getSize());
                if (!result.isSuccess()) {
                    String msg = StringUtils.format((String)"Cache entry[%s:%,d] too large for storage[%s:%,d/%,d] to maintain suggested freeSpace[%d], current freeSpace is [%d].", (Object[])new Object[]{entry.getId(), entry.getSize(), this.getPath(), this.availableSizeBytes(), this.maxSizeBytes, this.freeSpaceToKeep, currFreeSpace});
                    if (weak) {
                        log.debug(msg, new Object[0]);
                    } else {
                        log.warn(msg, new Object[0]);
                    }
                    return ReclaimResult.failed(this.freeSpaceToKeep + entry.getSize());
                }
                bytesReclaimed += result.bytesReclaimed;
                evicted.addAll(result.getEvictions());
            }
        }
        return new ReclaimResult(true, entry.getSize(), bytesReclaimed, evicted);
    }

    @GuardedBy(value="lock")
    private void unmountReclaimed(ReclaimResult reclaimResult) {
        if (reclaimResult != null) {
            for (WeakCacheEntry removed : reclaimResult.getEvictions()) {
                this.weakCacheEntries.computeIfAbsent(removed.cacheEntry.getId(), cacheEntryIdentifier -> {
                    if (!this.staticCacheEntries.containsKey(cacheEntryIdentifier)) {
                        removed.unmount();
                        this.stats.get().unmount();
                    }
                    return null;
                });
            }
        }
    }

    public int getWeakEntryCount() {
        this.lock.readLock().lock();
        try {
            int n = this.weakCacheEntries.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    public long getActiveWeakHolds() {
        this.lock.readLock().lock();
        try {
            long l = this.weakCacheEntries.values().stream().filter(WeakCacheEntry::isHeld).count();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stats getStats() {
        return this.stats.get();
    }

    public void resetStats() {
        this.stats.set(new Stats());
    }

    @GuardedBy(value="lock")
    private ReclaimResult reclaim(long sizeToReclaim) {
        return this.reclaimHelper(sizeToReclaim, new ArrayList<WeakCacheEntry>());
    }

    @GuardedBy(value="lock")
    private ReclaimResult reclaimHelper(long sizeToReclaim, List<WeakCacheEntry> droppedEntries) {
        if (this.head == null) {
            return ReclaimResult.failed(sizeToReclaim);
        }
        long sizeFreed = 0L;
        WeakCacheEntry startEntry = null;
        boolean unmarked = false;
        while (this.hand != null && sizeFreed < sizeToReclaim && startEntry != this.hand) {
            if (startEntry == null) {
                startEntry = this.hand;
            }
            if (this.hand.isHeld()) {
                this.hand = this.hand.prev;
            } else if (this.hand.visited) {
                unmarked = true;
                this.hand.visited = false;
                this.hand = this.hand.prev;
            } else {
                WeakCacheEntry toRemove = this.hand;
                this.hand = this.hand.prev;
                WeakCacheEntry removed = this.weakCacheEntries.remove(toRemove.cacheEntry.getId());
                if (removed == null) {
                    throw DruidException.defensive((String)"Weakly held cache entry[%s] already removed from map, how can this be?", (Object[])new Object[]{toRemove.cacheEntry.getId()});
                }
                this.unlinkWeakEntry(removed);
                this.stats.get().evict();
                toRemove.next = null;
                toRemove.prev = null;
                droppedEntries.add(toRemove);
                sizeFreed += toRemove.cacheEntry.getSize();
                startEntry = null;
            }
            if (this.hand != null) continue;
            this.hand = this.tail;
        }
        if (unmarked && sizeFreed < sizeToReclaim) {
            return this.reclaimHelper(sizeToReclaim - sizeFreed, droppedEntries);
        }
        if (sizeFreed >= sizeToReclaim) {
            return new ReclaimResult(true, sizeToReclaim, sizeFreed, droppedEntries);
        }
        for (WeakCacheEntry entry : droppedEntries) {
            this.linkNewWeakEntry(new WeakCacheEntry(entry.cacheEntry));
            this.weakCacheEntries.put(entry.cacheEntry.getId(), entry);
        }
        return ReclaimResult.failed(sizeToReclaim);
    }

    public long availableSizeBytes() {
        return this.maxSizeBytes - this.currSizeBytes.get();
    }

    public long currentSizeBytes() {
        return this.currSizeBytes.get();
    }

    public long currentWeakSizeBytes() {
        return this.currWeakSizeBytes.get();
    }

    static final class WeakCacheEntry {
        private final CacheEntry cacheEntry;
        private final Phaser holdReferents = new Phaser(1){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                if (registeredParties != 0) {
                    log.error("registeredParties[%s] is not 0", new Object[]{registeredParties});
                }
                try {
                    cacheEntry.unmount();
                }
                catch (Exception e) {
                    try {
                        log.error((Throwable)e, "Exception while closing reference counted object[%s]", new Object[]{cacheEntry.getId()});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
        };
        private WeakCacheEntry prev;
        private WeakCacheEntry next;
        private volatile boolean visited;

        private WeakCacheEntry(CacheEntry cacheEntry) {
            this.cacheEntry = cacheEntry;
        }

        boolean isHeld() {
            return this.holdReferents.getRegisteredParties() > 1;
        }

        private boolean hold() {
            return this.holdReferents.register() >= 0;
        }

        private int release() {
            return this.holdReferents.arriveAndDeregister();
        }

        private void unmount() {
            this.holdReferents.arriveAndDeregister();
        }
    }

    public static final class ReclaimResult {
        private final boolean success;
        private final long spaceRequired;
        private final long bytesReclaimed;
        private final List<WeakCacheEntry> evictions;

        public static ReclaimResult failed(long spaceRequired) {
            return new ReclaimResult(false, spaceRequired, 0L, List.of());
        }

        ReclaimResult(boolean success, long spaceRequired, long bytesReclaimed, List<WeakCacheEntry> evictions) {
            this.success = success;
            this.spaceRequired = spaceRequired;
            this.bytesReclaimed = bytesReclaimed;
            this.evictions = evictions;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public List<WeakCacheEntry> getEvictions() {
            return this.evictions;
        }
    }

    public static final class Stats {
        private final AtomicLong loadCount = new AtomicLong(0L);
        private final AtomicLong rejectionCount = new AtomicLong(0L);
        private final AtomicLong hitCount = new AtomicLong(0L);
        private final AtomicLong evictionCount = new AtomicLong(0L);
        private final AtomicLong unmountCount = new AtomicLong(0L);

        public void hit() {
            this.hitCount.getAndIncrement();
        }

        public long getHitCount() {
            return this.hitCount.get();
        }

        public void load() {
            this.loadCount.getAndIncrement();
        }

        public long getLoadCount() {
            return this.loadCount.get();
        }

        public void evict() {
            this.evictionCount.getAndIncrement();
        }

        public long getEvictionCount() {
            return this.evictionCount.get();
        }

        public void unmount() {
            this.unmountCount.getAndIncrement();
        }

        public long getUnmountCount() {
            return this.unmountCount.get();
        }

        public void reject() {
            this.rejectionCount.getAndIncrement();
        }

        public long getRejectCount() {
            return this.rejectionCount.get();
        }
    }

    public static class ReservationHold<TEntry extends CacheEntry>
    implements Closeable {
        private final TEntry entry;
        private final Runnable releaseHold;

        public ReservationHold(TEntry entry, Runnable releaseHold) {
            this.entry = entry;
            this.releaseHold = releaseHold;
        }

        public TEntry getEntry() {
            return this.entry;
        }

        @Override
        public void close() {
            this.releaseHold.run();
        }
    }
}

