/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.java.util.common.IAE;

public class TableSpec {
    private final String type;
    private final Map<String, Object> properties;
    private final List<ColumnSpec> columns;

    @JsonCreator
    public TableSpec(@JsonProperty(value="type") String type, @JsonProperty(value="properties") @Nullable Map<String, Object> properties, @JsonProperty(value="columns") @Nullable List<ColumnSpec> columns) {
        this.type = type;
        this.properties = properties == null ? Collections.emptyMap() : properties;
        this.columns = columns == null ? Collections.emptyList() : columns;
    }

    public TableSpec withProperties(Map<String, Object> properties) {
        return new TableSpec(this.type, properties, this.columns);
    }

    public TableSpec withColumns(List<ColumnSpec> columns) {
        return new TableSpec(this.type, this.properties, columns);
    }

    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> properties() {
        return this.properties;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ColumnSpec> columns() {
        return this.columns;
    }

    public void validate() {
        if (Strings.isNullOrEmpty((String)this.type)) {
            throw new IAE("Table type is required", new Object[0]);
        }
    }

    public String toString() {
        return CatalogUtils.toString(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TableSpec other = (TableSpec)o;
        return Objects.equals(this.type, other.type) && Objects.equals(this.columns, other.columns) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.columns, this.properties);
    }
}

