/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.server.metrics.TaskSlotCountStatsProvider;

public class TaskSlotCountStatsMonitor
extends AbstractMonitor {
    private final TaskSlotCountStatsProvider statsProvider;

    @Inject
    public TaskSlotCountStatsMonitor(TaskSlotCountStatsProvider statsProvider) {
        this.statsProvider = statsProvider;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        this.emit(emitter, "taskSlot/total/count", this.statsProvider.getTotalTaskSlotCount());
        this.emit(emitter, "taskSlot/idle/count", this.statsProvider.getIdleTaskSlotCount());
        this.emit(emitter, "taskSlot/used/count", this.statsProvider.getUsedTaskSlotCount());
        this.emit(emitter, "taskSlot/lazy/count", this.statsProvider.getLazyTaskSlotCount());
        this.emit(emitter, "taskSlot/blacklisted/count", this.statsProvider.getBlacklistedTaskSlotCount());
        return true;
    }

    private void emit(ServiceEmitter emitter, String key, Map<String, Long> counts) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        if (counts != null) {
            counts.forEach((k, v) -> {
                builder.setDimension("category", k);
                emitter.emit((ServiceEventBuilder)builder.setMetric(key, (Number)v));
            });
        }
    }
}

