/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.CharUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.eclipse.jetty.server.Response;

public class StandardResponseHeaderFilterHolder
implements ServletFilterHolder {
    private static final Set<String> STANDARD_HEADERS = ImmutableSet.of((Object)"Cache-Control", (Object)"Content-Security-Policy", (Object)"Strict-Transport-Security");
    private static final String DEFAULT_CONTENT_SECURITY_POLICY = "frame-ancestors 'none'";
    private final String contentSecurityPolicy;

    @Inject
    public StandardResponseHeaderFilterHolder(ServerConfig serverConfig) {
        this.contentSecurityPolicy = StandardResponseHeaderFilterHolder.asContentSecurityPolicyHeaderValue(serverConfig.getContentSecurityPolicy());
    }

    public static void deduplicateHeadersInProxyServlet(HttpServletResponse proxyResponse, org.eclipse.jetty.client.api.Response serverResponse) {
        for (String headerName : STANDARD_HEADERS) {
            if (!serverResponse.getHeaders().containsKey(headerName) || !proxyResponse.containsHeader(headerName)) continue;
            ((Response)proxyResponse).getHttpFields().remove(headerName);
        }
    }

    static String asContentSecurityPolicyHeaderValue(@Nullable String contentSecurityPolicy) {
        if (contentSecurityPolicy == null || contentSecurityPolicy.trim().isEmpty()) {
            return DEFAULT_CONTENT_SECURITY_POLICY;
        }
        for (int i = 0; i < contentSecurityPolicy.length(); ++i) {
            if (CharUtils.isAscii((char)contentSecurityPolicy.charAt(i))) continue;
            throw new IAE("Content-Security-Policy header value must be fully ASCII", new Object[0]);
        }
        return contentSecurityPolicy;
    }

    @Override
    public Filter getFilter() {
        return new StandardResponseHeaderFilter(this.contentSecurityPolicy);
    }

    @Override
    public Class<? extends Filter> getFilterClass() {
        return StandardResponseHeaderFilter.class;
    }

    @Override
    public Map<String, String> getInitParameters() {
        return Collections.emptyMap();
    }

    @Override
    public String getPath() {
        return "/*";
    }

    @Override
    @Nullable
    public EnumSet<DispatcherType> getDispatcherType() {
        return null;
    }

    static class StandardResponseHeaderFilter
    implements Filter {
        private final String contentSecurityPolicy;

        public StandardResponseHeaderFilter(String contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy;
        }

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (!"POST".equals(httpRequest.getMethod())) {
                httpResponse.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
                httpResponse.setHeader("Content-Security-Policy", this.contentSecurityPolicy);
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

