/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public abstract class MetadataCleanupDuty
implements CoordinatorDuty {
    private static final Logger log = new Logger(MetadataCleanupDuty.class);
    private final String entryType;
    private final CoordinatorStat cleanupCountStat;
    private final MetadataCleanupConfig cleanupConfig;
    private DateTime lastCleanupTime = DateTimes.utc((long)0L);

    protected MetadataCleanupDuty(String entryType, MetadataCleanupConfig cleanupConfig, CoordinatorStat cleanupCountStat) {
        this.entryType = entryType;
        this.cleanupConfig = cleanupConfig;
        this.cleanupCountStat = cleanupCountStat;
        if (cleanupConfig.isCleanupEnabled()) {
            log.debug("Enabled cleanup of [%s] with period [%s] and durationToRetain [%s].", new Object[]{entryType, cleanupConfig.getCleanupPeriod(), cleanupConfig.getDurationToRetain()});
        }
    }

    @Override
    @Nullable
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (!this.cleanupConfig.isCleanupEnabled()) {
            return params;
        }
        DateTime now = this.getCurrentTime();
        if (this.lastCleanupTime.plus((ReadableDuration)this.cleanupConfig.getCleanupPeriod()).isBefore((ReadableInstant)now)) {
            this.lastCleanupTime = now;
            try {
                DateTime minCreatedTime = now.minus((ReadableDuration)this.cleanupConfig.getDurationToRetain());
                int deletedEntries = this.cleanupEntriesCreatedBefore(minCreatedTime);
                if (deletedEntries > 0) {
                    log.info("Removed [%,d] [%s] created before [%s].", new Object[]{deletedEntries, this.entryType, minCreatedTime});
                }
                params.getCoordinatorStats().add(this.cleanupCountStat, deletedEntries);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to perform cleanup of [%s]", new Object[]{this.entryType});
            }
        }
        return params;
    }

    protected abstract int cleanupEntriesCreatedBefore(DateTime var1);

    protected DateTime getCurrentTime() {
        return DateTimes.nowUtc();
    }
}

