/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.BadJsonQueryException;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResourceQueryResultPusherFactory;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.ResourceIOReaderWriterFactory;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;

@LazySingleton
@Path(value="/druid/v2/")
public class QueryResource
implements QueryCountStatsProvider {
    protected static final EmittingLogger log = new EmittingLogger(QueryResource.class);
    public static final EmittingLogger NO_STACK_LOGGER = log.noStackTrace();
    @Deprecated
    protected static final String APPLICATION_SMILE = "application/smile";
    public static final String HEADER_RESPONSE_CONTEXT = "X-Druid-Response-Context";
    public static final String HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String QUERY_ID_RESPONSE_HEADER = "X-Druid-Query-Id";
    public static final String ERROR_MESSAGE_TRAILER_HEADER = "X-Error-Message";
    public static final String RESPONSE_COMPLETE_TRAILER_HEADER = "X-Druid-Response-Complete";
    public static final String HEADER_ETAG = "ETag";
    protected final QueryLifecycleFactory queryLifecycleFactory;
    protected final ObjectMapper jsonMapper;
    protected final QueryScheduler queryScheduler;
    protected final AuthorizerMapper authorizerMapper;
    private final QueryResourceQueryResultPusherFactory queryResultPusherFactory;
    protected final ResourceIOReaderWriterFactory resourceIOReaderWriterFactory;
    private final AtomicLong successfulQueryCount = new AtomicLong();
    private final AtomicLong failedQueryCount = new AtomicLong();
    private final AtomicLong interruptedQueryCount = new AtomicLong();
    private final AtomicLong timedOutQueryCount = new AtomicLong();
    private final QueryResourceQueryMetricCounter counter = new QueryResourceQueryMetricCounter();

    @Inject
    public QueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, QueryScheduler queryScheduler, AuthorizerMapper authorizerMapper, QueryResourceQueryResultPusherFactory queryResultPusherFactory, ResourceIOReaderWriterFactory resourceIOReaderWriterFactory) {
        this.queryLifecycleFactory = queryLifecycleFactory;
        this.jsonMapper = jsonMapper;
        this.queryScheduler = queryScheduler;
        this.authorizerMapper = authorizerMapper;
        this.queryResultPusherFactory = queryResultPusherFactory;
        this.resourceIOReaderWriterFactory = resourceIOReaderWriterFactory;
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="id") String queryId, @Context HttpServletRequest req) {
        AuthorizationResult authResult;
        Set<String> datasources;
        if (log.isDebugEnabled()) {
            log.debug("Received cancel request for query [%s]", new Object[]{queryId});
        }
        if ((datasources = this.queryScheduler.getQueryDatasources(queryId)) == null) {
            log.warn("QueryId [%s] not registered with QueryScheduler, cannot cancel", new Object[]{queryId});
            datasources = new TreeSet<String>();
        }
        if (!(authResult = AuthorizationUtils.authorizeAllResourceActions(req, (Iterable<ResourceAction>)Iterables.transform(datasources, AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR), this.authorizerMapper)).allowAccessWithNoRestriction()) {
            throw new ForbiddenException(authResult.getErrorMessage());
        }
        this.queryScheduler.cancelQuery(queryId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    @Nullable
    public Response doPost(InputStream in, @QueryParam(value="pretty") String pretty, @Context HttpServletRequest req) throws IOException {
        ResourceIOReaderWriterFactory.ResourceIOReaderWriter io = this.resourceIOReaderWriterFactory.factorize(req, pretty != null);
        String currThreadName = Thread.currentThread().getName();
        try {
            AuthorizationResult authResult;
            Query<?> query;
            try {
                query = this.readQuery(req, in, io);
            }
            catch (QueryException e) {
                Response response = io.getResponseWriter().buildNonOkResponse(e.getFailType().getExpectedStatus(), (Exception)((Object)e));
                Thread.currentThread().setName(currThreadName);
                return response;
            }
            QueryLifecycle queryLifecycle = this.queryLifecycleFactory.factorize();
            queryLifecycle.initialize(query);
            String queryThreadName = queryLifecycle.threadName(currThreadName);
            Thread.currentThread().setName(queryThreadName);
            if (log.isDebugEnabled()) {
                log.debug("Got query [%s]", new Object[]{queryLifecycle.getQuery()});
            }
            try {
                authResult = queryLifecycle.authorize(req);
            }
            catch (RuntimeException e) {
                QueryException qe = e instanceof QueryException ? (QueryException)((Object)e) : new QueryInterruptedException((Throwable)e);
                Response response = io.getResponseWriter().buildNonOkResponse(qe.getFailType().getExpectedStatus(), (Exception)((Object)qe));
                Thread.currentThread().setName(currThreadName);
                return response;
            }
            if (!authResult.allowBasicAccess()) {
                log.info("Query[%s] forbidden due to reason[%s]", new Object[]{query.getId(), authResult.getErrorMessage()});
                throw new ForbiddenException(authResult.getErrorMessage());
            }
            QueryResourceQueryResultPusherFactory.QueryResourceQueryResultPusher pusher = this.queryResultPusherFactory.factorize(this.counter, req, queryLifecycle, io);
            Response response = pusher.push();
            return response;
        }
        catch (Exception e) {
            if (e instanceof ForbiddenException && !req.isAsyncStarted()) {
                throw e;
            }
            log.warn((Throwable)e, "Uncaught exception from query processing.  This should be caught and handled directly.", new Object[0]);
            AsyncContext asyncContext = req.startAsync();
            try {
                HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
                if (!response.isCommitted()) {
                    response.setStatus(500);
                    response.setContentType("application/json");
                    try (ServletOutputStream out = response.getOutputStream();){
                        QueryException responseException = new QueryException("Unknown exception", "Unhandled exception made it to the top", e.getClass().getName(), req.getRemoteHost());
                        out.write(this.jsonMapper.writeValueAsBytes((Object)responseException));
                    }
                }
                Response response2 = null;
                return response2;
            }
            finally {
                asyncContext.complete();
            }
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    private Query<?> readQuery(HttpServletRequest req, InputStream in, ResourceIOReaderWriterFactory.ResourceIOReaderWriter ioReaderWriter) throws IOException {
        Query baseQuery;
        try {
            baseQuery = (Query)ioReaderWriter.getRequestMapper().readValue(in, Query.class);
        }
        catch (JsonParseException e) {
            throw new BadJsonQueryException(e);
        }
        String prevEtag = QueryResource.getPreviousEtag(req);
        if (prevEtag == null) {
            return baseQuery;
        }
        return baseQuery.withOverriddenContext(QueryContexts.override((Map)baseQuery.getContext(), (String)HEADER_IF_NONE_MATCH, (Object)prevEtag));
    }

    private static String getPreviousEtag(HttpServletRequest req) {
        return req.getHeader(HEADER_IF_NONE_MATCH);
    }

    @Override
    public long getSuccessfulQueryCount() {
        return this.successfulQueryCount.get();
    }

    @Override
    public long getFailedQueryCount() {
        return this.failedQueryCount.get();
    }

    @Override
    public long getInterruptedQueryCount() {
        return this.interruptedQueryCount.get();
    }

    @Override
    public long getTimedOutQueryCount() {
        return this.timedOutQueryCount.get();
    }

    @VisibleForTesting
    public static void transferEntityTag(ResponseContext context, Response.ResponseBuilder builder) {
        Object entityTag = context.remove(ResponseContext.Keys.ETAG);
        if (entityTag != null) {
            builder.header(HEADER_ETAG, entityTag);
        }
    }

    private class QueryResourceQueryMetricCounter
    implements QueryMetricCounter {
        private QueryResourceQueryMetricCounter() {
        }

        @Override
        public void incrementSuccess() {
            QueryResource.this.successfulQueryCount.incrementAndGet();
        }

        @Override
        public void incrementFailed() {
            QueryResource.this.failedQueryCount.incrementAndGet();
        }

        @Override
        public void incrementInterrupted() {
            QueryResource.this.interruptedQueryCount.incrementAndGet();
        }

        @Override
        public void incrementTimedOut() {
            QueryResource.this.timedOutQueryCount.incrementAndGet();
        }
    }

    public static interface QueryMetricCounter {
        public void incrementSuccess();

        public void incrementFailed();

        public void incrementInterrupted();

        public void incrementTimedOut();
    }

    static class NativeQueryWriter
    implements QueryResultPusher.Writer {
        private final SerializerProvider serializers;
        private final JsonGenerator jsonGenerator;

        public NativeQueryWriter(ObjectMapper responseMapper, OutputStream out) throws IOException {
            this.serializers = responseMapper.getSerializerProviderInstance();
            this.jsonGenerator = responseMapper.createGenerator(out);
        }

        @Override
        public void writeResponseStart() throws IOException {
            this.jsonGenerator.writeStartArray();
        }

        @Override
        public void writeRow(Object obj) throws IOException {
            JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)this.jsonGenerator, (SerializerProvider)this.serializers, (Object)obj);
        }

        @Override
        public void writeResponseEnd() throws IOException {
            this.jsonGenerator.writeEndArray();
        }

        @Override
        public void close() throws IOException {
            this.jsonGenerator.close();
        }
    }
}

