/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.google.inject.Inject;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.CacheStats;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;

public class CacheMonitor
extends AbstractMonitor {
    volatile Cache cache;
    private final CachePopulatorStats cachePopulatorStats;
    private volatile CacheStats prevCacheStats = null;
    private volatile CachePopulatorStats.Snapshot prevCachePopulatorStats = null;

    @Inject
    public CacheMonitor(CachePopulatorStats cachePopulatorStats) {
        this.cachePopulatorStats = cachePopulatorStats;
    }

    @Inject(optional=true)
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.cache != null) {
            CacheStats currCacheStats = this.cache.getStats();
            CacheStats deltaCacheStats = currCacheStats.delta(this.prevCacheStats);
            CachePopulatorStats.Snapshot currCachePopulatorStats = this.cachePopulatorStats.snapshot();
            CachePopulatorStats.Snapshot deltaCachePopulatorStats = currCachePopulatorStats.delta(this.prevCachePopulatorStats);
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            this.emitStats(emitter, "query/cache/delta", deltaCachePopulatorStats, deltaCacheStats, builder);
            this.emitStats(emitter, "query/cache/total", currCachePopulatorStats, currCacheStats, builder);
            this.prevCachePopulatorStats = currCachePopulatorStats;
            this.prevCacheStats = currCacheStats;
            this.cache.doMonitor(emitter);
        }
        return true;
    }

    private void emitStats(ServiceEmitter emitter, String metricPrefix, CachePopulatorStats.Snapshot cachePopulatorStats, CacheStats cacheStats, ServiceMetricEvent.Builder builder) {
        if (this.cache != null) {
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/numEntries", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumEntries()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/sizeBytes", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getSizeInBytes()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/hits", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumHits()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/misses", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumMisses()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/evictions", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumEvictions()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/hitRate", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.hitRate()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/averageBytes", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.averageBytes()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/timeouts", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumTimeouts()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/errors", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumErrors()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/put/ok", (Object[])new Object[]{metricPrefix}), (Number)cachePopulatorStats.getNumOk()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/put/error", (Object[])new Object[]{metricPrefix}), (Number)cachePopulatorStats.getNumError()));
            emitter.emit((ServiceEventBuilder)builder.setMetric(StringUtils.format((String)"%s/put/oversized", (Object[])new Object[]{metricPrefix}), (Number)cachePopulatorStats.getNumOversized()));
        }
    }
}

