/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.initialization.ServerConfig;

public class SetAndVerifyContextQueryRunner<T>
implements QueryRunner<T> {
    private final ServerConfig serverConfig;
    private final QueryRunner<T> baseRunner;
    private final long startTimeMillis;

    public SetAndVerifyContextQueryRunner(ServerConfig serverConfig, QueryRunner<T> baseRunner) {
        this.serverConfig = serverConfig;
        this.baseRunner = baseRunner;
        this.startTimeMillis = System.currentTimeMillis();
    }

    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        return this.baseRunner.run(QueryPlus.wrap(this.withTimeoutAndMaxScatterGatherBytes(queryPlus.getQuery(), this.serverConfig)), responseContext);
    }

    public Query<T> withTimeoutAndMaxScatterGatherBytes(Query<T> query, ServerConfig serverConfig) {
        Query newQuery = Queries.withMaxScatterGatherBytes((Query)Queries.withDefaultTimeout(query, (long)Math.min(serverConfig.getDefaultQueryTimeout(), serverConfig.getMaxQueryTimeout())), (long)serverConfig.getMaxScatterGatherBytes());
        newQuery.context().verifyMaxQueryTimeout(serverConfig.getMaxQueryTimeout());
        QueryContext context = newQuery.context();
        long failTime = context.hasTimeout() ? this.startTimeMillis + context.getTimeout() : this.startTimeMillis + serverConfig.getMaxQueryTimeout();
        return newQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"queryFailTime", (Object)(failTime > 0L ? failTime : Long.MAX_VALUE)));
    }
}

