/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.utils.JvmUtils;

public class SegmentLoaderConfig {
    @JsonProperty
    private List<StorageLocationConfig> locations = Collections.emptyList();
    @JsonProperty(value="lazyLoadOnStart")
    private boolean lazyLoadOnStart = false;
    @JsonProperty(value="deleteOnRemove")
    private boolean deleteOnRemove = true;
    @JsonProperty(value="dropSegmentDelayMillis")
    private int dropSegmentDelayMillis = (int)TimeUnit.SECONDS.toMillis(30L);
    @JsonProperty(value="announceIntervalMillis")
    private int announceIntervalMillis = 0;
    @JsonProperty(value="numLoadingThreads")
    private int numLoadingThreads = Math.max(1, JvmUtils.getRuntimeInfo().getAvailableProcessors() / 6);
    @JsonProperty(value="numBootstrapThreads")
    private Integer numBootstrapThreads = null;
    @JsonProperty(value="numThreadsToLoadSegmentsIntoPageCacheOnDownload")
    private int numThreadsToLoadSegmentsIntoPageCacheOnDownload = 0;
    @JsonProperty(value="numThreadsToLoadSegmentsIntoPageCacheOnBootstrap")
    private Integer numThreadsToLoadSegmentsIntoPageCacheOnBootstrap = null;
    @JsonProperty
    private File infoDir = null;
    @JsonProperty
    private int statusQueueMaxSize = 100;
    private long combinedMaxSize = 0L;

    public List<StorageLocationConfig> getLocations() {
        return this.locations;
    }

    public boolean isLazyLoadOnStart() {
        return this.lazyLoadOnStart;
    }

    public boolean isDeleteOnRemove() {
        return this.deleteOnRemove;
    }

    public int getDropSegmentDelayMillis() {
        return this.dropSegmentDelayMillis;
    }

    public int getAnnounceIntervalMillis() {
        return this.announceIntervalMillis;
    }

    public int getNumLoadingThreads() {
        return this.numLoadingThreads;
    }

    public int getNumBootstrapThreads() {
        return this.numBootstrapThreads == null ? this.numLoadingThreads : this.numBootstrapThreads;
    }

    public int getNumThreadsToLoadSegmentsIntoPageCacheOnDownload() {
        return this.numThreadsToLoadSegmentsIntoPageCacheOnDownload;
    }

    public int getNumThreadsToLoadSegmentsIntoPageCacheOnBootstrap() {
        return this.numThreadsToLoadSegmentsIntoPageCacheOnBootstrap == null ? this.numThreadsToLoadSegmentsIntoPageCacheOnDownload : this.numThreadsToLoadSegmentsIntoPageCacheOnBootstrap;
    }

    public File getInfoDir() {
        return this.infoDir;
    }

    public int getStatusQueueMaxSize() {
        return this.statusQueueMaxSize;
    }

    public long getCombinedMaxSize() {
        if (this.combinedMaxSize == 0L) {
            this.combinedMaxSize = this.getLocations().stream().mapToLong(StorageLocationConfig::getMaxSize).sum();
        }
        return this.combinedMaxSize;
    }

    public SegmentLoaderConfig withLocations(List<StorageLocationConfig> locations) {
        SegmentLoaderConfig retVal = new SegmentLoaderConfig();
        retVal.locations = Lists.newArrayList(locations);
        retVal.deleteOnRemove = this.deleteOnRemove;
        retVal.infoDir = this.infoDir;
        return retVal;
    }

    public List<StorageLocation> toStorageLocations() {
        return this.getLocations().stream().map(locationConfig -> new StorageLocation(locationConfig.getPath(), locationConfig.getMaxSize(), locationConfig.getFreeSpacePercent())).collect(Collectors.toList());
    }

    public String toString() {
        return "SegmentLoaderConfig{locations=" + String.valueOf(this.locations) + ", deleteOnRemove=" + this.deleteOnRemove + ", dropSegmentDelayMillis=" + this.dropSegmentDelayMillis + ", infoDir=" + String.valueOf(this.infoDir) + "}";
    }
}

