/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.coordinator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.druid.client.BootstrapSegmentsResponse;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordination.LoadableDataSegment;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Interval;

public class CoordinatorClientImpl
implements CoordinatorClient {
    private final ServiceClient client;
    private final ObjectMapper jsonMapper;

    public CoordinatorClientImpl(ServiceClient client, ObjectMapper jsonMapper) {
        this.client = client;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public ListenableFuture<Boolean> isHandoffComplete(String dataSource, SegmentDescriptor descriptor) {
        String path = StringUtils.format((String)"/druid/coordinator/v1/datasources/%s/handoffComplete?interval=%s&partitionNumber=%d&version=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), StringUtils.urlEncode((String)descriptor.getInterval().toString()), descriptor.getPartitionNumber(), StringUtils.urlEncode((String)descriptor.getVersion())});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler()), holder -> (Boolean)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), Boolean.class));
    }

    @Override
    public ListenableFuture<DataSegment> fetchSegment(String dataSource, String segmentId, boolean includeUnused) {
        String path = StringUtils.format((String)"/druid/coordinator/v1/metadata/datasources/%s/segments/%s?includeUnused=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), StringUtils.urlEncode((String)segmentId), includeUnused ? "true" : "false"});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler()), holder -> (DataSegment)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), DataSegment.class));
    }

    @Override
    public Iterable<ImmutableSegmentLoadInfo> fetchServerViewSegments(String dataSource, List<Interval> intervals) {
        ArrayList<ImmutableSegmentLoadInfo> retVal = new ArrayList<ImmutableSegmentLoadInfo>();
        for (Interval interval : intervals) {
            String intervalString = StringUtils.replace((String)interval.toString(), (String)"/", (String)"_");
            String path = StringUtils.format((String)"/druid/coordinator/v1/datasources/%s/intervals/%s/serverview?full", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), intervalString});
            ListenableFuture segments = FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, path), new BytesFullResponseHandler()), holder -> (Iterable)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<Iterable<ImmutableSegmentLoadInfo>>(){}));
            ((Iterable)FutureUtils.getUnchecked((ListenableFuture)segments, (boolean)true)).forEach(retVal::add);
        }
        return retVal;
    }

    @Override
    public ListenableFuture<List<DataSegment>> fetchUsedSegments(String dataSource, List<Interval> intervals) {
        String path = StringUtils.format((String)"/druid/coordinator/v1/metadata/datasources/%s/segments?full", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource)});
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, path).jsonContent(this.jsonMapper, intervals), new BytesFullResponseHandler()), holder -> (List)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<List<DataSegment>>(){}));
    }

    @Override
    public ListenableFuture<List<DataSourceInformation>> fetchDataSourceInformation(Set<String> dataSources) {
        String path = "/druid/coordinator/v1/metadata/dataSourceInformation";
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/dataSourceInformation").jsonContent(this.jsonMapper, dataSources), new BytesFullResponseHandler()), holder -> (List)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<List<DataSourceInformation>>(){}));
    }

    @Override
    public ListenableFuture<BootstrapSegmentsResponse> fetchBootstrapSegments() {
        String path = "/druid/coordinator/v1/metadata/bootstrapSegments";
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.POST, "/druid/coordinator/v1/metadata/bootstrapSegments"), new InputStreamResponseHandler()), in -> new BootstrapSegmentsResponse(new JsonParserIterator<DataSegment>(this.jsonMapper.getTypeFactory().constructType(LoadableDataSegment.class), (Future<InputStream>)Futures.immediateFuture((Object)in), this.jsonMapper)));
    }

    @Override
    public CoordinatorClientImpl withRetryPolicy(ServiceRetryPolicy retryPolicy) {
        return new CoordinatorClientImpl(this.client.withRetryPolicy(retryPolicy), this.jsonMapper);
    }

    @Override
    public ListenableFuture<Set<String>> fetchDataSourcesWithUsedSegments() {
        String path = "/druid/coordinator/v1/metadata/datasources";
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, "/druid/coordinator/v1/metadata/datasources"), new BytesFullResponseHandler()), holder -> (Set)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), (TypeReference)new TypeReference<Set<String>>(){}));
    }

    @Override
    public ListenableFuture<CompactionStatusResponse> getCompactionSnapshots(@Nullable String dataSource) {
        StringBuilder pathBuilder = new StringBuilder("/druid/coordinator/v1/compaction/status");
        if (dataSource != null && !dataSource.isEmpty()) {
            pathBuilder.append("?").append("dataSource=").append(StringUtils.urlEncode((String)dataSource));
        }
        return FutureUtils.transform(this.client.asyncRequest(new RequestBuilder(HttpMethod.GET, pathBuilder.toString()), new BytesFullResponseHandler()), holder -> (CompactionStatusResponse)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])holder.getContent(), CompactionStatusResponse.class));
    }
}

