/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.client.CoordinatorSegmentWatcherConfig;
import org.apache.druid.client.DirectDruidClientFactory;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.InventoryView;
import org.apache.druid.client.SegmentLoadInfo;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;

@ManageLifecycle
public class CoordinatorServerView
implements InventoryView {
    private static final Logger log = new Logger(CoordinatorServerView.class);
    private final Object lock = new Object();
    private final Map<SegmentId, SegmentLoadInfo> segmentLoadInfos;
    private final Map<String, VersionedIntervalTimeline<String, SegmentLoadInfo>> timelines;
    private final ConcurrentMap<String, QueryRunner> serverQueryRunners;
    private final ConcurrentMap<TimelineServerView.TimelineCallback, Executor> timelineCallbacks;
    private final ServerInventoryView baseView;
    private final CoordinatorSegmentWatcherConfig segmentWatcherConfig;
    private final CountDownLatch initialized = new CountDownLatch(1);
    private final ServiceEmitter emitter;
    @Nullable
    private final DirectDruidClientFactory druidClientFactory;

    @Inject
    public CoordinatorServerView(ServerInventoryView baseView, CoordinatorSegmentWatcherConfig segmentWatcherConfig, ServiceEmitter emitter, @Nullable DirectDruidClientFactory druidClientFactory) {
        this.baseView = baseView;
        this.segmentWatcherConfig = segmentWatcherConfig;
        this.emitter = emitter;
        this.druidClientFactory = druidClientFactory;
        this.segmentLoadInfos = new HashMap<SegmentId, SegmentLoadInfo>();
        this.timelines = new HashMap<String, VersionedIntervalTimeline<String, SegmentLoadInfo>>();
        this.serverQueryRunners = new ConcurrentHashMap<String, QueryRunner>();
        this.timelineCallbacks = new ConcurrentHashMap<TimelineServerView.TimelineCallback, Executor>();
        ExecutorService exec = Execs.singleThreaded((String)"CoordinatorServerView-%s");
        baseView.registerSegmentCallback(exec, new ServerView.SegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                CoordinatorServerView.this.serverAddedSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                CoordinatorServerView.this.serverRemovedSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentViewInitialized() {
                CoordinatorServerView.this.initialized.countDown();
                CoordinatorServerView.this.runTimelineCallbacks(TimelineServerView.TimelineCallback::timelineInitialized);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentSchemasAnnounced(SegmentSchemas segmentSchemas) {
                CoordinatorServerView.this.runTimelineCallbacks(callback -> callback.segmentSchemasAnnounced(segmentSchemas));
                return ServerView.CallbackAction.CONTINUE;
            }
        });
        baseView.registerServerRemovedCallback(exec, new ServerView.ServerRemovedCallback(){

            @Override
            public ServerView.CallbackAction serverRemoved(DruidServer server) {
                CoordinatorServerView.this.removeServer(server);
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    @LifecycleStart
    public void start() throws InterruptedException {
        if (this.segmentWatcherConfig.isAwaitInitializationOnStart()) {
            long startMillis = System.currentTimeMillis();
            log.info("%s waiting for initialization.", new Object[]{this.getClass().getSimpleName()});
            this.initialized.await();
            long endMillis = System.currentTimeMillis();
            log.info("%s initialized in [%,d] ms.", new Object[]{this.getClass().getSimpleName(), endMillis - startMillis});
            this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("serverview/init/time", (Number)(endMillis - startMillis)));
        }
    }

    private void removeServer(DruidServer server) {
        for (DataSegment segment : server.iterateAllSegments()) {
            this.serverRemovedSegment(server.getMetadata(), segment);
        }
        this.serverQueryRunners.remove(server.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverAddedSegment(DruidServerMetadata server, DataSegment segment) {
        SegmentId segmentId = segment.getId();
        Object object = this.lock;
        synchronized (object) {
            QueryRunner queryRunner;
            log.debug("Adding segment[%s] for server[%s]", new Object[]{segment, server});
            SegmentLoadInfo segmentLoadInfo = this.segmentLoadInfos.get(segmentId);
            if (segmentLoadInfo == null) {
                segmentLoadInfo = new SegmentLoadInfo(segment);
                VersionedIntervalTimeline timeline = this.timelines.get(segment.getDataSource());
                if (timeline == null) {
                    timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
                    this.timelines.put(segment.getDataSource(), (VersionedIntervalTimeline<String, SegmentLoadInfo>)timeline);
                }
                timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segmentLoadInfo));
                this.segmentLoadInfos.put(segmentId, segmentLoadInfo);
            }
            if (this.druidClientFactory != null && (queryRunner = (QueryRunner)this.serverQueryRunners.get(server.getName())) == null) {
                DruidServer inventoryValue = this.baseView.getInventoryValue(server.getName());
                if (inventoryValue == null) {
                    log.warn("Could not find server[%s] in inventory. Skipping addition of segment[%s].", new Object[]{server.getName(), segmentId});
                    return;
                }
                this.serverQueryRunners.put(server.getName(), this.druidClientFactory.makeDirectClient(inventoryValue));
            }
            segmentLoadInfo.addServer(server);
            this.runTimelineCallbacks(callback -> callback.segmentAdded(server, segment));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverRemovedSegment(DruidServerMetadata server, DataSegment segment) {
        SegmentId segmentId = segment.getId();
        Object object = this.lock;
        synchronized (object) {
            log.debug("Removing segment[%s] from server[%s].", new Object[]{segmentId, server});
            SegmentLoadInfo segmentLoadInfo = this.segmentLoadInfos.get(segmentId);
            if (segmentLoadInfo == null) {
                log.warn("Told to remove non-existant segment[%s]", new Object[]{segmentId});
                return;
            }
            if (segmentLoadInfo.removeServer(server)) {
                this.runTimelineCallbacks(callback -> callback.serverSegmentRemoved(server, segment));
            }
            if (segmentLoadInfo.isEmpty()) {
                VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.timelines.get(segment.getDataSource());
                this.segmentLoadInfos.remove(segmentId);
                PartitionChunk removedPartition = timeline.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)new SegmentLoadInfo(segment)));
                if (removedPartition == null) {
                    log.warn("Asked to remove timeline entry[interval: %s, version: %s] that doesn't exist", new Object[]{segment.getInterval(), segment.getVersion()});
                } else {
                    this.runTimelineCallbacks(callback -> callback.segmentRemoved(segment));
                }
            }
        }
    }

    public void registerTimelineCallback(Executor exec, TimelineServerView.TimelineCallback callback) {
        this.timelineCallbacks.put(callback, exec);
    }

    private void runTimelineCallbacks(Function<TimelineServerView.TimelineCallback, ServerView.CallbackAction> function) {
        for (Map.Entry entry : this.timelineCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(() -> {
                if (ServerView.CallbackAction.UNREGISTER == function.apply((TimelineServerView.TimelineCallback)entry.getKey())) {
                    this.timelineCallbacks.remove(entry.getKey());
                }
            });
        }
    }

    public QueryRunner getQueryRunner(String serverName) {
        return (QueryRunner)this.serverQueryRunners.get(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedIntervalTimeline<String, SegmentLoadInfo> getTimeline(DataSource dataSource) {
        String table = (String)Iterables.getOnlyElement((Iterable)dataSource.getTableNames());
        Object object = this.lock;
        synchronized (object) {
            return this.timelines.get(table);
        }
    }

    public Map<SegmentId, SegmentLoadInfo> getLoadInfoForAllSegments() {
        return this.segmentLoadInfos;
    }

    @Override
    public DruidServer getInventoryValue(String serverKey) {
        return this.baseView.getInventoryValue(serverKey);
    }

    @Override
    public Collection<DruidServer> getInventory() {
        return this.baseView.getInventory();
    }

    @Override
    public boolean isStarted() {
        return this.baseView.isStarted();
    }

    @Override
    public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
        return this.baseView.isSegmentLoadedByServer(serverKey, segment);
    }
}

