/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.column.DoublesColumnWithNulls;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoublesColumn
implements NumericColumn {
    final ColumnarDoubles column;

    public static DoublesColumn create(ColumnarDoubles column, ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            return new DoublesColumn(column);
        }
        return new DoublesColumnWithNulls(column, nullValueBitmap);
    }

    DoublesColumn(ColumnarDoubles columnarDoubles) {
        this.column = columnarDoubles;
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
        return this.column.makeColumnValueSelector(offset, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        return this.column.makeVectorValueSelector(offset, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        return (long)this.column.get(rowNum);
    }

    @Override
    public void close() {
        this.column.close();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("column", this.column);
    }
}

