/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import java.util.Map;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnType;

public class DimValHolder {
    private final Object topNMetricVal;
    private final Object dimValue;
    private final ColumnType dimType;
    private final Object dimValIndex;
    private final Map<String, Object> metricValues;

    public DimValHolder(Object topNMetricVal, Object dimValue, ColumnType dimType, Object dimValIndex, Map<String, Object> metricValues) {
        this.topNMetricVal = topNMetricVal;
        this.dimValue = dimValue;
        this.dimType = dimType;
        this.dimValIndex = dimValIndex;
        this.metricValues = metricValues;
    }

    public Object getTopNMetricVal() {
        return this.topNMetricVal;
    }

    public Object getDimValue() {
        return this.dimValue;
    }

    public ColumnType getDimType() {
        return this.dimType;
    }

    public Object getDimValIndex() {
        return this.dimValIndex;
    }

    public Map<String, Object> getMetricValues() {
        return this.metricValues;
    }

    public static class Builder {
        private Object topNMetricVal = null;
        private Object dimValue = null;
        private Object dimValIndex = null;
        private ColumnType dimType = null;
        private Map<String, Object> metricValues = null;

        public Builder withTopNMetricVal(Object topNMetricVal) {
            this.topNMetricVal = topNMetricVal;
            return this;
        }

        public Builder withDimValue(Object dimValue, ColumnType type) {
            this.dimValue = DimensionHandlerUtils.convertObjectToType(dimValue, type);
            this.dimType = type;
            return this;
        }

        public Builder withDimValIndex(Object dimValIndex) {
            this.dimValIndex = dimValIndex;
            return this;
        }

        public Builder withMetricValues(Map<String, Object> metricValues) {
            this.metricValues = metricValues;
            return this;
        }

        public DimValHolder build() {
            return new DimValHolder(this.topNMetricVal, this.dimValue, this.dimType, this.dimValIndex, this.metricValues);
        }
    }
}

