/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.concrete;

import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.FrameColumnReaders;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.AbstractFrameRowsAndColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class ColumnBasedFrameRowsAndColumns
extends AbstractFrameRowsAndColumns {
    public ColumnBasedFrameRowsAndColumns(Frame frame, RowSignature signature) {
        super(frame.ensureColumnar(), signature);
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (!this.colCache.containsKey(name)) {
            int columnIndex = this.signature.indexOf(name);
            if (columnIndex < 0) {
                this.colCache.put(name, null);
            } else {
                ColumnType columnType = this.signature.getColumnType(columnIndex).orElseThrow(() -> DruidException.defensive("just got the id [%s][%s], why is columnType not there?", columnIndex, name));
                this.colCache.put(name, FrameColumnReaders.create(name, columnIndex, columnType).readRACColumn(this.frame));
            }
        }
        return (Column)this.colCache.get(name);
    }
}

