/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;

public class InvalidFieldException
extends RuntimeException {
    @Nullable
    private final String source;
    @Nullable
    private final String column;
    @Nullable
    private final Integer rowNumber;
    @Nullable
    private final String errorMsg;

    private InvalidFieldException(@Nullable @JsonProperty(value="source") String source, @Nullable @JsonProperty(value="column") String column, @Nullable @JsonProperty(value="rowNumber") Integer rowNumber, @Nullable @JsonProperty(value="message") String errorMsg) {
        super(StringUtils.format("Error[%s] while writing a field for source[%s], rowNumber[%d], column[%s].", errorMsg, source, rowNumber, column));
        this.column = column;
        this.rowNumber = rowNumber;
        this.source = source;
        this.errorMsg = errorMsg;
    }

    @Nullable
    public String getColumn() {
        return this.column;
    }

    @Nullable
    public Integer getRowNumber() {
        return this.rowNumber;
    }

    @Nullable
    public String getSource() {
        return this.source;
    }

    @Nullable
    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidFieldException that = (InvalidFieldException)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.column, that.column) && Objects.equals(this.rowNumber, that.rowNumber) && Objects.equals(this.errorMsg, that.errorMsg);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.column, this.rowNumber, this.errorMsg);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(InvalidFieldException invalidFieldException) {
        return new Builder(invalidFieldException);
    }

    public static class Builder {
        @Nullable
        private String column;
        @Nullable
        private Integer rowNumber;
        @Nullable
        private String source;
        @Nullable
        private String errorMsg;
        @Nullable
        private Throwable cause;

        public Builder() {
        }

        public Builder(InvalidFieldException invalidFieldException) {
            this.source = invalidFieldException.source;
            this.rowNumber = invalidFieldException.rowNumber;
            this.column = invalidFieldException.column;
            this.errorMsg = invalidFieldException.errorMsg;
            this.cause = invalidFieldException.getCause();
        }

        public InvalidFieldException build() {
            InvalidFieldException invalidFieldException = new InvalidFieldException(this.source, this.column, this.rowNumber, this.errorMsg);
            if (this.cause != null) {
                invalidFieldException.initCause(this.cause);
            }
            return invalidFieldException;
        }

        public Builder column(String val) {
            this.column = val;
            return this;
        }

        public Builder rowNumber(Integer val) {
            this.rowNumber = val;
            return this;
        }

        public Builder source(String val) {
            this.source = val;
            return this;
        }

        public Builder errorMsg(String val) {
            this.errorMsg = val;
            return this;
        }

        public Builder cause(Throwable val) {
            this.cause = val;
            return this;
        }
    }
}

