/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.NumericFieldWriter;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoubleFieldWriter
extends NumericFieldWriter {
    private final BaseDoubleColumnValueSelector selector;
    private final FrameType frameType;

    public static DoubleFieldWriter forPrimitive(BaseDoubleColumnValueSelector selector, FrameType frameType) {
        return new DoubleFieldWriter(selector, false, frameType);
    }

    public static DoubleFieldWriter forArray(BaseDoubleColumnValueSelector selector, FrameType frameType) {
        return new DoubleFieldWriter(selector, true, frameType);
    }

    private DoubleFieldWriter(BaseDoubleColumnValueSelector selector, boolean forArray, FrameType frameType) {
        super(selector, forArray);
        this.selector = selector;
        this.frameType = frameType;
    }

    @Override
    public int getNumericSizeBytes() {
        return 8;
    }

    @Override
    public void writeSelectorToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, this.selector.getDouble());
    }

    @Override
    public void writeNullToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, 0.0);
    }

    private void writeToMemory(WritableMemory memory, long position, double value) {
        memory.putLong(position, TransformUtils.transformFromDouble(value, this.frameType));
    }
}

