/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class DefaultColumnSelectorFactoryMaker
implements ColumnSelectorFactoryMaker {
    private final RowsAndColumns rac;

    public DefaultColumnSelectorFactoryMaker(RowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    public ColumnSelectorFactory make(AtomicInteger rowIdProvider) {
        return new ColumnAccessorBasedColumnSelectorFactory(rowIdProvider, this.rac);
    }

    public static class ColumnAccessorBasedColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final Map<String, ColumnAccessor> accessorCache = new HashMap<String, ColumnAccessor>();
        private final AtomicInteger cellIdSupplier;
        private final RowsAndColumns rac;

        public ColumnAccessorBasedColumnSelectorFactory(AtomicInteger cellIdSupplier, RowsAndColumns rac) {
            this.cellIdSupplier = cellIdSupplier;
            this.rac = rac;
        }

        @Override
        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return this.withColumnAccessor(dimensionSpec.getDimension(), columnAccessor -> {
                int rowCounter;
                if (columnAccessor == null) {
                    return DimensionSelector.nilSelector();
                }
                boolean maybeSupportsUtf8 = columnAccessor.getType().is(ValueType.STRING);
                int rowCount = columnAccessor.numRows();
                for (rowCounter = 0; maybeSupportsUtf8 && rowCounter < rowCount && columnAccessor.isNull(rowCounter); ++rowCounter) {
                }
                if (rowCounter == rowCount) {
                    return DimensionSelector.nilSelector();
                }
                boolean supportsUtf8 = maybeSupportsUtf8 && columnAccessor.getObject(rowCounter) instanceof ByteBuffer;
                return new BaseSingleValueDimensionSelector((ColumnAccessor)columnAccessor, supportsUtf8){
                    final /* synthetic */ ColumnAccessor val$columnAccessor;
                    final /* synthetic */ boolean val$supportsUtf8;
                    {
                        this.val$columnAccessor = columnAccessor;
                        this.val$supportsUtf8 = bl;
                    }

                    @Override
                    @Nullable
                    protected String getValue() {
                        Object retVal = this.val$columnAccessor.getObject(cellIdSupplier.get());
                        if (retVal == null) {
                            return null;
                        }
                        if (retVal instanceof ByteBuffer) {
                            return StringUtils.fromUtf8(((ByteBuffer)retVal).asReadOnlyBuffer());
                        }
                        return String.valueOf(retVal);
                    }

                    @Override
                    @Nullable
                    public ByteBuffer lookupNameUtf8(int id) {
                        return (ByteBuffer)this.val$columnAccessor.getObject(cellIdSupplier.get());
                    }

                    @Override
                    public boolean supportsLookupNameUtf8() {
                        return this.val$supportsUtf8;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    }
                };
            });
        }

        @Override
        public ColumnValueSelector makeColumnValueSelector(@Nonnull String columnName) {
            return this.withColumnAccessor(columnName, columnAccessor -> {
                if (columnAccessor == null) {
                    return DimensionSelector.nilSelector();
                }
                ColumnType type = columnAccessor.getType();
                switch ((ValueType)type.getType()) {
                    case STRING: {
                        return new StringColumnValueSelector((ColumnAccessor)columnAccessor);
                    }
                    case COMPLEX: {
                        return new ComplexColumnValueSelector((ColumnAccessor)columnAccessor);
                    }
                }
                return new PassThroughColumnValueSelector((ColumnAccessor)columnAccessor);
            });
        }

        @Override
        @Nullable
        public ColumnCapabilities getColumnCapabilities(String column) {
            return this.withColumnAccessor(column, columnAccessor -> {
                if (columnAccessor == null) {
                    return null;
                }
                return new ColumnCapabilitiesImpl().setType(columnAccessor.getType()).setHasMultipleValues(false).setDictionaryEncoded(false).setHasBitmapIndexes(false);
            });
        }

        private <T> T withColumnAccessor(String column, Function<ColumnAccessor, T> fn) {
            ColumnAccessor retVal = this.accessorCache.get(column);
            if (retVal == null) {
                Column racColumn = this.rac.findColumn(column);
                retVal = racColumn == null ? null : racColumn.toAccessor();
                this.accessorCache.put(column, retVal);
            }
            return fn.apply(retVal);
        }

        private class StringColumnValueSelector
        implements ColumnValueSelector {
            private final ColumnAccessor columnAccessor;

            public StringColumnValueSelector(ColumnAccessor columnAccessor) {
                this.columnAccessor = columnAccessor;
            }

            @Override
            @Nullable
            public Object getObject() {
                Object retVal = this.columnAccessor.getObject(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
                if (retVal instanceof ByteBuffer) {
                    return StringUtils.fromUtf8(((ByteBuffer)retVal).asReadOnlyBuffer());
                }
                return retVal;
            }

            @Override
            public Class classOfObject() {
                return String.class;
            }

            @Override
            public boolean isNull() {
                return this.columnAccessor.isNull(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public long getLong() {
                return this.columnAccessor.getLong(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public float getFloat() {
                return this.columnAccessor.getFloat(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public double getDouble() {
                return this.columnAccessor.getDouble(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }

        private class ComplexColumnValueSelector
        implements ColumnValueSelector {
            private final AtomicReference<Class> myClazz;
            private final ColumnAccessor columnAccessor;

            public ComplexColumnValueSelector(ColumnAccessor columnAccessor) {
                this.columnAccessor = columnAccessor;
                this.myClazz = new AtomicReference<Object>(null);
            }

            @Override
            @Nullable
            public Object getObject() {
                return this.columnAccessor.getObject(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public Class classOfObject() {
                Class retVal = this.myClazz.get();
                if (retVal == null) {
                    retVal = this.findClazz();
                    this.myClazz.set(retVal);
                }
                return retVal;
            }

            private Class findClazz() {
                ColumnType type = this.columnAccessor.getType();
                if (type.getType() == ValueType.COMPLEX) {
                    ComplexMetricSerde serdeForType = ComplexMetrics.getSerdeForType(type.getComplexTypeName());
                    if (serdeForType != null && serdeForType.getObjectStrategy() != null) {
                        return serdeForType.getObjectStrategy().getClazz();
                    }
                    for (int i = 0; i < this.columnAccessor.numRows(); ++i) {
                        Object obj = this.columnAccessor.getObject(i);
                        if (obj == null) continue;
                        return obj.getClass();
                    }
                    return Object.class;
                }
                throw DruidException.defensive("this class cannot handle type [%s]", type);
            }

            @Override
            public boolean isNull() {
                return this.columnAccessor.isNull(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public long getLong() {
                return this.columnAccessor.getLong(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public float getFloat() {
                return this.columnAccessor.getFloat(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public double getDouble() {
                return this.columnAccessor.getDouble(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }

        private class PassThroughColumnValueSelector
        implements ColumnValueSelector {
            private final Class myClazz;
            private final ColumnAccessor columnAccessor;

            public PassThroughColumnValueSelector(ColumnAccessor columnAccessor) {
                this.columnAccessor = columnAccessor;
                switch ((ValueType)columnAccessor.getType().getType()) {
                    case LONG: {
                        this.myClazz = Long.TYPE;
                        break;
                    }
                    case DOUBLE: {
                        this.myClazz = Double.TYPE;
                        break;
                    }
                    case FLOAT: {
                        this.myClazz = Float.TYPE;
                        break;
                    }
                    case ARRAY: {
                        this.myClazz = Object[].class;
                        break;
                    }
                    default: {
                        throw DruidException.defensive("this class cannot handle type [%s]", columnAccessor.getType());
                    }
                }
            }

            @Override
            @Nullable
            public Object getObject() {
                return this.columnAccessor.getObject(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public Class classOfObject() {
                return this.myClazz;
            }

            @Override
            public boolean isNull() {
                return this.columnAccessor.isNull(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public long getLong() {
                return this.columnAccessor.getLong(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public float getFloat() {
                return this.columnAccessor.getFloat(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public double getDouble() {
                return this.columnAccessor.getDouble(ColumnAccessorBasedColumnSelectorFactory.this.cellIdSupplier.get());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
    }
}

