/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.collection;

import org.apache.datasketches.memory.Memory;

public class HashTableUtils {
    private HashTableUtils() {
    }

    public static int previousPowerOfTwo(int n) {
        if (n > 0) {
            return Integer.highestOneBit(n);
        }
        return Integer.MIN_VALUE;
    }

    public static int hashMemory(Memory memory, long position, int length) {
        switch (length) {
            case 4: {
                return memory.getInt(position);
            }
            case 8: {
                return 31 * (31 + memory.getInt(position)) + memory.getInt(position + 4L);
            }
            case 9: {
                return 31 * (31 * (31 + memory.getInt(position)) + memory.getInt(position + 4L)) + memory.getByte(position + 8L);
            }
            case 12: {
                return 31 * (31 * (31 + memory.getInt(position)) + memory.getInt(position + 4L)) + memory.getInt(position + 8L);
            }
            case 13: {
                return 31 * (31 * (31 * (31 + memory.getInt(position)) + memory.getInt(position + 4L)) + memory.getInt(position + 8L)) + memory.getByte(position + 12L);
            }
            case 16: {
                return 31 * (31 * (31 * (31 + memory.getInt(position)) + memory.getInt(position + 4L)) + memory.getInt(position + 8L)) + memory.getInt(position + 12L);
            }
        }
        int hashCode = 1;
        int remainingBytes = length;
        long pos = position;
        while (remainingBytes >= 4) {
            hashCode = 31 * hashCode + memory.getInt(pos);
            remainingBytes -= 4;
            pos += 4L;
        }
        if (remainingBytes == 1) {
            hashCode = 31 * hashCode + memory.getByte(pos);
        } else if (remainingBytes == 2) {
            hashCode = 31 * hashCode + memory.getByte(pos);
            hashCode = 31 * hashCode + memory.getByte(pos + 1L);
        } else if (remainingBytes == 3) {
            hashCode = 31 * hashCode + memory.getByte(pos);
            hashCode = 31 * hashCode + memory.getByte(pos + 1L);
            hashCode = 31 * hashCode + memory.getByte(pos + 2L);
        }
        return hashCode;
    }

    public static boolean memoryEquals(Memory memory1, long offset1, Memory memory2, long offset2, int length) {
        switch (length) {
            case 4: {
                return memory1.getInt(offset1) == memory2.getInt(offset2);
            }
            case 8: {
                return memory1.getLong(offset1) == memory2.getLong(offset2);
            }
            case 9: {
                return memory1.getLong(offset1) == memory2.getLong(offset2) && memory1.getByte(offset1 + 8L) == memory2.getByte(offset2 + 8L);
            }
            case 12: {
                return memory1.getInt(offset1) == memory2.getInt(offset2) && memory1.getLong(offset1 + 4L) == memory2.getLong(offset2 + 4L);
            }
            case 13: {
                return memory1.getLong(offset1) == memory2.getLong(offset2) && memory1.getInt(offset1 + 8L) == memory2.getInt(offset2 + 8L) && memory1.getByte(offset1 + 4L + 8L) == memory2.getByte(offset2 + 4L + 8L);
            }
            case 16: {
                return memory1.getLong(offset1) == memory2.getLong(offset2) && memory1.getLong(offset1 + 8L) == memory2.getLong(offset2 + 8L);
            }
        }
        return memory1.equalTo(offset1, (Object)memory2, offset2, (long)length);
    }
}

