/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.DoubleUnivariateLongFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongUnivariateLongFunctionVectorProcessor;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public class TimestampExtractExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_extract";

    @Override
    public String name() {
        return FN_NAME;
    }

    private long evalAsLong(DateTime dateTime, Unit unit) {
        switch (unit) {
            case EPOCH: {
                return dateTime.getMillis() / 1000L;
            }
            case MILLISECOND: {
                return dateTime.millisOfSecond().get();
            }
            case SECOND: {
                return dateTime.secondOfMinute().get();
            }
            case MINUTE: {
                return dateTime.minuteOfHour().get();
            }
            case HOUR: {
                return dateTime.hourOfDay().get();
            }
            case DAY: {
                return dateTime.dayOfMonth().get();
            }
            case DOW: 
            case ISODOW: {
                return dateTime.dayOfWeek().get();
            }
            case DOY: {
                return dateTime.dayOfYear().get();
            }
            case WEEK: {
                return dateTime.weekOfWeekyear().get();
            }
            case MONTH: {
                return dateTime.monthOfYear().get();
            }
            case QUARTER: {
                return (dateTime.monthOfYear().get() - 1) / 3 + 1;
            }
            case YEAR: 
            case ISOYEAR: {
                return dateTime.year().get();
            }
            case DECADE: {
                return dateTime.year().get() / 10;
            }
        }
        throw this.validationFailed("unhandled unit[%s]", new Object[]{unit});
    }

    private double evalAsDouble(DateTime dateTime, Unit unit) {
        switch (unit) {
            case CENTURY: {
                return Math.ceil((double)dateTime.year().get() / 100.0);
            }
            case MILLENNIUM: {
                return Math.ceil((double)dateTime.year().get() / 1000.0);
            }
        }
        throw this.validationFailed("unhandled unit[%s]", new Object[]{unit});
    }

    private static ExpressionType getOutputExpressionType(Unit unit) {
        switch (unit) {
            case CENTURY: 
            case MILLENNIUM: {
                return ExpressionType.DOUBLE;
            }
        }
        return ExpressionType.LONG;
    }

    private static ISOChronology computeChronology(List<Expr> args, Expr.ObjectBinding bindings) {
        String timeZoneVal = (String)args.get(2).eval(bindings).value();
        return timeZoneVal != null ? ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString(timeZoneVal)) : ISOChronology.getInstanceUTC();
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 2, 3);
        if (!args.get(1).isLiteral() || args.get(1).getLiteralValue() == null) {
            throw this.validationFailed("unit arg must be literal", new Object[0]);
        }
        Unit unit = Unit.valueOf(StringUtils.toUpperCase((String)args.get(1).getLiteralValue()));
        if (args.size() > 2) {
            if (args.get(2).isLiteral()) {
                DateTimeZone timeZone = ExprUtils.toTimeZone(args.get(2));
                ISOChronology chronology = ISOChronology.getInstance((DateTimeZone)timeZone);
                return new TimestampExtractExpr(args, unit, chronology);
            }
            return new TimestampExtractDynamicExpr(args, unit);
        }
        return new TimestampExtractExpr(args, unit, ISOChronology.getInstanceUTC());
    }

    public static enum Unit {
        EPOCH,
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        DOW,
        ISODOW,
        DOY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR,
        ISOYEAR,
        DECADE,
        CENTURY,
        MILLENNIUM;

    }

    public class TimestampExtractExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final ISOChronology chronology;
        private final Unit unit;

        private TimestampExtractExpr(List<Expr> args, Unit unit, ISOChronology chronology) {
            super(TimestampExtractExprMacro.this, args);
            this.unit = unit;
            this.chronology = chronology;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.value() == null) {
                return ExprEval.ofType(TimestampExtractExprMacro.getOutputExpressionType(this.unit), null);
            }
            DateTime dateTime = new DateTime(eval.value(), (Chronology)this.chronology);
            switch ((ExprType)TimestampExtractExprMacro.getOutputExpressionType(this.unit).getType()) {
                case LONG: {
                    return ExprEval.of(TimestampExtractExprMacro.this.evalAsLong(dateTime, this.unit));
                }
                case DOUBLE: {
                    return ExprEval.of(TimestampExtractExprMacro.this.evalAsDouble(dateTime, this.unit));
                }
            }
            throw DruidException.defensive("Unexpected type[%s]", TimestampExtractExprMacro.getOutputExpressionType(this.unit).getType());
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return TimestampExtractExprMacro.getOutputExpressionType(this.unit);
        }

        @Override
        public boolean canVectorize(Expr.InputBindingInspector inspector) {
            return ((Expr)this.args.get(0)).canVectorize(inspector);
        }

        @Override
        public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
            ExprVectorProcessor<double[]> processor = TimestampExtractExprMacro.getOutputExpressionType(this.unit).is(ExprType.DOUBLE) ? new DoubleUnivariateLongFunctionVectorProcessor(((Expr)this.args.get(0)).asVectorProcessor(inspector), input -> TimestampExtractExprMacro.this.evalAsDouble(new DateTime(input, (Chronology)this.chronology), this.unit)) : new LongUnivariateLongFunctionVectorProcessor(((Expr)this.args.get(0)).asVectorProcessor(inspector), input -> TimestampExtractExprMacro.this.evalAsLong(new DateTime(input, (Chronology)this.chronology), this.unit));
            return processor;
        }
    }

    public class TimestampExtractDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Unit unit;

        private TimestampExtractDynamicExpr(List<Expr> args, Unit unit) {
            super(TimestampExtractExprMacro.this, args);
            this.unit = unit;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.value() == null) {
                return ExprEval.ofType(TimestampExtractExprMacro.getOutputExpressionType(this.unit), null);
            }
            ISOChronology chronology = TimestampExtractExprMacro.computeChronology(this.args, bindings);
            DateTime dateTime = new DateTime(eval.value(), (Chronology)chronology);
            switch ((ExprType)TimestampExtractExprMacro.getOutputExpressionType(this.unit).getType()) {
                case LONG: {
                    return ExprEval.of(TimestampExtractExprMacro.this.evalAsLong(dateTime, this.unit));
                }
                case DOUBLE: {
                    return ExprEval.of(TimestampExtractExprMacro.this.evalAsDouble(dateTime, this.unit));
                }
            }
            throw DruidException.defensive("Unexpected type[%s]", TimestampExtractExprMacro.getOutputExpressionType(this.unit).getType());
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return TimestampExtractExprMacro.getOutputExpressionType(this.unit);
        }
    }
}

