/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.NullableNumericAggregateCombiner;
import org.apache.druid.query.aggregation.NullableNumericAggregator;
import org.apache.druid.query.aggregation.NullableNumericBufferAggregator;
import org.apache.druid.query.aggregation.NullableNumericVectorAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.BaseNullableColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;

public abstract class NullableNumericAggregatorFactory<T extends BaseNullableColumnValueSelector>
extends AggregatorFactory {
    public boolean forceNotNullable() {
        return false;
    }

    @Override
    public final Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        T selector = this.selector(columnSelectorFactory);
        Aggregator aggregator = this.factorize(columnSelectorFactory, selector);
        if (this.forceNotNullable()) {
            return aggregator;
        }
        return new NullableNumericAggregator(aggregator, this.makeNullSelector(selector, columnSelectorFactory));
    }

    @Override
    public final BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        T selector = this.selector(columnSelectorFactory);
        BufferAggregator aggregator = this.factorizeBuffered(columnSelectorFactory, selector);
        if (this.forceNotNullable()) {
            return aggregator;
        }
        return new NullableNumericBufferAggregator(aggregator, this.makeNullSelector(selector, columnSelectorFactory));
    }

    @Override
    public final VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory) {
        Preconditions.checkState((boolean)this.canVectorize(columnSelectorFactory), (Object)"Cannot vectorize");
        VectorValueSelector selector = this.vectorSelector(columnSelectorFactory);
        VectorAggregator aggregator = this.factorizeVector(columnSelectorFactory, selector);
        if (this.forceNotNullable()) {
            return aggregator;
        }
        return new NullableNumericVectorAggregator(aggregator, selector);
    }

    @Override
    public final AggregateCombiner makeNullableAggregateCombiner() {
        AggregateCombiner combiner = this.makeAggregateCombiner();
        if (this.forceNotNullable()) {
            return combiner;
        }
        return new NullableNumericAggregateCombiner(combiner);
    }

    @Override
    public final int getMaxIntermediateSizeWithNulls() {
        if (this.forceNotNullable()) {
            return this.getMaxIntermediateSize();
        }
        return this.getMaxIntermediateSize() + 1;
    }

    private BaseNullableColumnValueSelector makeNullSelector(T selector, ColumnSelectorFactory columnSelectorFactory) {
        if (this.useGetObject(columnSelectorFactory)) {
            BaseObjectColumnValueSelector objectSelector = (BaseObjectColumnValueSelector)selector;
            return () -> objectSelector.getObject() == null;
        }
        return selector;
    }

    protected abstract T selector(ColumnSelectorFactory var1);

    protected boolean useGetObject(ColumnSelectorFactory columnSelectorFactory) {
        return false;
    }

    protected VectorValueSelector vectorSelector(VectorColumnSelectorFactory columnSelectorFactory) {
        throw new UnsupportedOperationException("Cannot vectorize");
    }

    protected abstract Aggregator factorize(ColumnSelectorFactory var1, T var2);

    protected abstract BufferAggregator factorizeBuffered(ColumnSelectorFactory var1, T var2);

    protected VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory, VectorValueSelector selector) {
        if (!this.canVectorize(columnSelectorFactory)) {
            throw new UnsupportedOperationException("Cannot vectorize");
        }
        throw new UnsupportedOperationException("canVectorize returned true but 'factorizeVector' is not implemented");
    }

    @Override
    public ColumnType getResultType() {
        return this.getIntermediateType();
    }
}

