/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.SegmentMapFunction;

public class UnionDataSource
implements DataSource {
    @JsonProperty(value="dataSources")
    private final List<DataSource> dataSources;

    @JsonCreator
    public UnionDataSource(@JsonProperty(value="dataSources") List<DataSource> dataSources) {
        if (dataSources == null || dataSources.isEmpty()) {
            throw new ISE("'dataSources' must be non-null and non-empty for 'union'", new Object[0]);
        }
        this.dataSources = dataSources;
    }

    @Override
    public Set<String> getTableNames() {
        if (!this.isTableBased()) {
            throw DruidException.defensive("contains non-table based datasource", new Object[0]);
        }
        return this.dataSources.stream().map(DataSource::getTableNames).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public boolean isTableBased() {
        return this.dataSources.stream().allMatch(dataSource -> dataSource instanceof TableDataSource || dataSource instanceof RestrictedDataSource);
    }

    @Override
    public List<DataSource> getChildren() {
        return ImmutableList.copyOf(this.dataSources);
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != this.dataSources.size()) {
            throw new IAE("Expected [%d] children, got [%d]", this.dataSources.size(), children.size());
        }
        return new UnionDataSource(children);
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.dataSources.stream().allMatch(DataSource::isGlobal);
    }

    @Override
    public boolean isProcessable() {
        return this.dataSources.stream().allMatch(DataSource::isProcessable);
    }

    @Override
    public SegmentMapFunction createSegmentMapFunction(Query query) {
        for (DataSource dataSource : this.dataSources) {
            if (dataSource.getChildren().isEmpty()) continue;
            throw new ISE("Union datasource with non-leaf inputs is not supported [%s]!", this.dataSources);
        }
        return SegmentMapFunction.IDENTITY;
    }

    @Override
    public byte[] getCacheKey() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionDataSource that = (UnionDataSource)o;
        return this.dataSources.equals(that.dataSources);
    }

    public int hashCode() {
        return this.dataSources.hashCode();
    }

    public String toString() {
        return "UnionDataSource{dataSources=" + this.dataSources + "}";
    }

    public static boolean isCompatibleDataSource(DataSource dataSource) {
        return dataSource instanceof TableDataSource || dataSource instanceof InlineDataSource;
    }
}

