/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;

abstract class UnaryExpr
implements Expr {
    final String op;
    final Expr expr;

    UnaryExpr(String op, Expr expr) {
        this.op = op;
        this.expr = expr;
    }

    abstract UnaryExpr copy(Expr var1);

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        Expr newExpr = this.expr.visit(shuttle);
        if (newExpr != this.expr) {
            return shuttle.visit(this.copy(newExpr));
        }
        return shuttle.visit(this);
    }

    @Override
    public Expr.BindingAnalysis analyzeInputs() {
        return this.expr.analyzeInputs().withScalarArguments((Set<Expr>)ImmutableSet.of((Object)this.expr));
    }

    @Override
    @Nullable
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return this.expr.getOutputType(inspector);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnaryExpr unaryExpr = (UnaryExpr)o;
        return Objects.equals(this.expr, unaryExpr.expr);
    }

    public int hashCode() {
        return Objects.hash(this.expr);
    }

    @Override
    public String stringify() {
        return StringUtils.format("%s%s", this.op, this.expr.stringify());
    }

    public String toString() {
        return StringUtils.format("%s%s", this.op, this.expr);
    }
}

