/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.FileEntity;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.data.input.impl.systemfield.SystemFieldInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.CollectionUtils;
import org.apache.druid.utils.Streams;

public class LocalInputSource
extends AbstractInputSource
implements SplittableInputSource<List<File>>,
SystemFieldInputSource {
    private static final Logger log = new Logger(LocalInputSource.class);
    public static final String TYPE_KEY = "local";
    @Nullable
    private final File baseDir;
    @Nullable
    private final String filter;
    private final List<File> files;
    private final SystemFields systemFields;

    @JsonCreator
    public LocalInputSource(@JsonProperty(value="baseDir") @Nullable File baseDir, @JsonProperty(value="filter") @Nullable String filter, @JsonProperty(value="files") @Nullable List<File> files, @JsonProperty(value="systemFields") @Nullable SystemFields systemFields) {
        this.baseDir = baseDir;
        this.filter = baseDir != null ? (String)Preconditions.checkNotNull((Object)filter, (Object)"filter") : filter;
        this.files = files == null ? Collections.emptyList() : files;
        SystemFields systemFields2 = this.systemFields = systemFields == null ? SystemFields.none() : systemFields;
        if (baseDir == null && CollectionUtils.isNullOrEmpty(files)) {
            throw new IAE("At least one of baseDir or files should be specified", new Object[0]);
        }
    }

    @Override
    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(TYPE_KEY);
    }

    public LocalInputSource(File baseDir, String filter) {
        this(baseDir, filter, null, SystemFields.none());
    }

    @Nullable
    public File getBaseDir() {
        return this.baseDir;
    }

    @Nullable
    @JsonProperty(value="baseDir")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String getBaseDirForSerialization() {
        if (this.baseDir == null) {
            return null;
        }
        return this.baseDir.getPath();
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFilter() {
        return this.filter;
    }

    @Override
    public Set<SystemField> getConfiguredSystemFields() {
        return this.systemFields.getFields();
    }

    public SystemFields getSystemFields() {
        return this.systemFields;
    }

    public List<File> getFiles() {
        return this.files;
    }

    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> getFilesForSerialization() {
        return this.getFiles().stream().map(File::getPath).collect(Collectors.toList());
    }

    @Override
    public Stream<InputSplit<List<File>>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return Streams.sequentialStreamFrom(this.getSplitFileIterator(inputFormat, this.getSplitHintSpecOrDefault(splitHintSpec))).map(InputSplit::new);
    }

    @Override
    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        return Iterators.size(this.getSplitFileIterator(inputFormat, this.getSplitHintSpecOrDefault(splitHintSpec)));
    }

    private Iterator<List<File>> getSplitFileIterator(InputFormat inputFormat, SplitHintSpec splitHintSpec) {
        Iterator<File> fileIterator = this.getFileIterator();
        return splitHintSpec.split(fileIterator, file -> new InputFileAttribute(file.length(), inputFormat != null ? inputFormat.getWeightedSize(file.getName(), file.length()) : file.length()));
    }

    @VisibleForTesting
    Iterator<File> getFileIterator() {
        return Iterators.filter((Iterator)Iterators.concat(this.getDirectoryListingIterator(), this.getFilesListIterator()), file -> file.length() > 0L);
    }

    private Iterator<File> getDirectoryListingIterator() {
        if (this.baseDir == null) {
            return Collections.emptyIterator();
        }
        Object fileFilter = this.files == null ? new WildcardFileFilter(this.filter) : new AndFileFilter((IOFileFilter)new WildcardFileFilter(this.filter), (IOFileFilter)new NotFileFilter((IOFileFilter)new NameFileFilter(this.files.stream().map(File::getName).collect(Collectors.toList()), IOCase.SENSITIVE)));
        Iterator fileIterator = FileUtils.iterateFiles((File)this.baseDir.getAbsoluteFile(), (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (!fileIterator.hasNext()) {
            log.info("Local inputSource filter [%s] for base dir [%s] did not match any files", this.filter, this.baseDir);
        }
        return fileIterator;
    }

    private Iterator<File> getFilesListIterator() {
        if (this.files == null) {
            return Collections.emptyIterator();
        }
        return this.files.iterator();
    }

    public SplittableInputSource<List<File>> withSplit(InputSplit<List<File>> split) {
        return new LocalInputSource(null, null, split.get(), this.systemFields);
    }

    @Override
    public Object getSystemFieldValue(InputEntity entity, SystemField field) {
        FileEntity fileEntity = (FileEntity)entity;
        switch (field) {
            case URI: {
                return fileEntity.getUri().toString();
            }
            case PATH: {
                return fileEntity.getFile().getPath();
            }
        }
        return null;
    }

    @Override
    public boolean needsFormat() {
        return true;
    }

    @Override
    protected InputSourceReader formattableReader(InputRowSchema inputRowSchema, InputFormat inputFormat, @Nullable File temporaryDirectory) {
        return new InputEntityIteratingReader(inputRowSchema, inputFormat, CloseableIterators.withEmptyBaggage(Iterators.transform(this.getFileIterator(), FileEntity::new)), SystemFieldDecoratorFactory.fromInputSource(this), temporaryDirectory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalInputSource that = (LocalInputSource)o;
        return Objects.equals(this.baseDir, that.baseDir) && Objects.equals(this.filter, that.filter) && Objects.equals(this.files, that.files) && Objects.equals(this.systemFields, that.systemFields);
    }

    public int hashCode() {
        return Objects.hash(this.baseDir, this.filter, this.files, this.systemFields);
    }

    public String toString() {
        return "LocalInputSource{baseDir=\"" + this.baseDir + "\", filter=" + this.filter + ", files=" + this.files + (String)(this.systemFields.getFields().isEmpty() ? "" : ", systemFields=" + this.systemFields) + "}";
    }
}

