/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.CloseableIteratorWithMetadata;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.utils.CollectionUtils;

public abstract class IntermediateRowParsingReader<T>
implements InputEntityReader {
    @Override
    public CloseableIterator<InputRow> read() throws IOException {
        final CloseableIteratorWithMetadata<T> intermediateRowIteratorWithMetadata = this.intermediateRowIteratorWithMetadata();
        return new CloseableIterator<InputRow>(){
            Iterator<InputRow> rows = null;
            long currentRecordNumber = 1L;

            @Override
            public boolean hasNext() {
                if (this.rows == null || !this.rows.hasNext()) {
                    if (!intermediateRowIteratorWithMetadata.hasNext()) {
                        return false;
                    }
                    Object row = intermediateRowIteratorWithMetadata.next();
                    try {
                        this.rows = IntermediateRowParsingReader.this.parseInputRows(row).iterator();
                        ++this.currentRecordNumber;
                    }
                    catch (IOException e) {
                        Map<String, Object> metadata = intermediateRowIteratorWithMetadata.currentMetadata();
                        String rowAsString = IntermediateRowParsingReader.this.intermediateRowAsString(row);
                        this.rows = new ExceptionThrowingIterator(new ParseException(rowAsString, (Throwable)e, IntermediateRowParsingReader.buildParseExceptionMessage(StringUtils.format("Unable to parse row [%s]", rowAsString), IntermediateRowParsingReader.this.source(), this.currentRecordNumber, metadata), new Object[0]));
                    }
                    catch (ParseException e) {
                        Map<String, Object> metadata = intermediateRowIteratorWithMetadata.currentMetadata();
                        this.rows = new ExceptionThrowingIterator(new ParseException(e.getInput(), e.isFromPartiallyValidRow(), IntermediateRowParsingReader.buildParseExceptionMessage(e.getMessage(), IntermediateRowParsingReader.this.source(), this.currentRecordNumber, metadata), new Object[0]));
                    }
                }
                return true;
            }

            @Override
            public InputRow next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.rows.next();
            }

            @Override
            public void close() throws IOException {
                intermediateRowIteratorWithMetadata.close();
            }
        };
    }

    @Override
    public CloseableIterator<InputRowListPlusRawValues> sample() throws IOException {
        final CloseableIteratorWithMetadata<T> delegate = this.intermediateRowIteratorWithMetadata();
        return new CloseableIterator<InputRowListPlusRawValues>(){

            @Override
            public void close() throws IOException {
                delegate.close();
            }

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public InputRowListPlusRawValues next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IntermediateRowParsingReader.this.sampleIntermediateRow(delegate.next(), delegate.currentMetadata());
            }
        };
    }

    private InputRowListPlusRawValues sampleIntermediateRow(T row, Map<String, Object> metadata) {
        List<InputRow> rows;
        List<Map<String, Object>> rawColumnsList;
        try {
            rawColumnsList = this.toMap(row);
        }
        catch (Exception e) {
            String rowAsString = this.intermediateRowAsString(row);
            return InputRowListPlusRawValues.of(null, new ParseException(rowAsString, (Throwable)e, IntermediateRowParsingReader.buildParseExceptionMessage(StringUtils.nonStrictFormat("Unable to parse row [%s] into JSON", rowAsString), this.source(), null, metadata), new Object[0]));
        }
        if (CollectionUtils.isNullOrEmpty(rawColumnsList)) {
            String rowAsString = this.intermediateRowAsString(row);
            return InputRowListPlusRawValues.of(null, new ParseException(rowAsString, IntermediateRowParsingReader.buildParseExceptionMessage(StringUtils.nonStrictFormat("No map object parsed for row [%s]", rowAsString), this.source(), null, metadata), new Object[0]));
        }
        try {
            rows = this.parseInputRows(row);
        }
        catch (ParseException e) {
            return InputRowListPlusRawValues.ofList(rawColumnsList, new ParseException(this.intermediateRowAsString(row), (Throwable)e, IntermediateRowParsingReader.buildParseExceptionMessage(e.getMessage(), this.source(), null, metadata), new Object[0]));
        }
        catch (IOException e) {
            String rowAsString = this.intermediateRowAsString(row);
            ParseException exception = new ParseException(rowAsString, (Throwable)e, IntermediateRowParsingReader.buildParseExceptionMessage(StringUtils.nonStrictFormat("Unable to parse row [%s] into inputRow", rowAsString), this.source(), null, metadata), new Object[0]);
            return InputRowListPlusRawValues.ofList(rawColumnsList, exception);
        }
        return InputRowListPlusRawValues.ofList(rawColumnsList, rows);
    }

    protected CloseableIterator<T> intermediateRowIterator() throws IOException {
        throw new UOE("intermediateRowIterator not implemented", new Object[0]);
    }

    protected CloseableIteratorWithMetadata<T> intermediateRowIteratorWithMetadata() throws IOException {
        return CloseableIteratorWithMetadata.withEmptyMetadata(this.intermediateRowIterator());
    }

    protected String intermediateRowAsString(@Nullable T row) {
        return String.valueOf(row);
    }

    @Nullable
    protected InputEntity source() {
        return null;
    }

    protected abstract List<InputRow> parseInputRows(T var1) throws IOException, ParseException;

    protected abstract List<Map<String, Object>> toMap(T var1) throws IOException;

    private static String buildParseExceptionMessage(@Nonnull String baseExceptionMessage, @Nullable InputEntity source, @Nullable Long recordNumber, @Nullable Map<String, Object> metadata) {
        StringBuilder sb = new StringBuilder();
        if (source != null && source.getUri() != null) {
            sb.append(StringUtils.format("Path: %s, ", source.getUri()));
        }
        if (recordNumber != null) {
            sb.append(StringUtils.format("Record: %d, ", recordNumber));
        }
        if (metadata != null) {
            metadata.entrySet().stream().map(entry -> StringUtils.format("%s: %s, ", entry.getKey(), entry.getValue().toString())).forEach(sb::append);
        }
        if (sb.length() == 0) {
            return baseExceptionMessage;
        }
        sb.setLength(sb.length() - 2);
        return baseExceptionMessage + " (" + sb + ")";
    }

    private static class ExceptionThrowingIterator
    implements CloseableIterator<InputRow> {
        private final Exception exception;
        private boolean thrown = false;

        private ExceptionThrowingIterator(Exception exception) {
            this.exception = exception;
        }

        @Override
        public boolean hasNext() {
            return !this.thrown;
        }

        @Override
        public InputRow next() {
            this.thrown = true;
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception);
        }

        @Override
        public void close() {
        }
    }
}

