/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Suppliers;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class NullColumnPartSerde
implements ColumnPartSerde {
    private static final Serializer NOOP_SERIALIZER = new Serializer(){

        @Override
        public long getSerializedSize() {
            return 0L;
        }

        @Override
        public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) {
        }
    };
    private final int numRows;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final NullDictionaryEncodedColumn nullDictionaryEncodedColumn;

    @JsonCreator
    public NullColumnPartSerde(@JsonProperty(value="numRows") int numRows, @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory) {
        this.numRows = numRows;
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.nullDictionaryEncodedColumn = new NullDictionaryEncodedColumn();
    }

    @JsonProperty
    public int getNumRows() {
        return this.numRows;
    }

    @Deprecated
    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @Override
    @Nullable
    public Serializer getSerializer() {
        return NOOP_SERIALIZER;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return (buffer, builder, columnConfig, parent) -> builder.setHasMultipleValues(false).setHasNulls(true).setIndexSupplier(null, true, false).setDictionaryEncodedColumnSupplier(Suppliers.ofInstance((Object)this.nullDictionaryEncodedColumn));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullColumnPartSerde partSerde = (NullColumnPartSerde)o;
        return this.numRows == partSerde.numRows && Objects.equals(this.bitmapSerdeFactory, partSerde.bitmapSerdeFactory);
    }

    public int hashCode() {
        return Objects.hash(this.numRows, this.bitmapSerdeFactory);
    }

    private final class NullDictionaryEncodedColumn
    implements DictionaryEncodedColumn<String> {
        private final DimensionSelector nullDimensionSelector = DimensionSelector.constant(null);

        private NullDictionaryEncodedColumn() {
        }

        @Override
        public int length() {
            return NullColumnPartSerde.this.numRows;
        }

        @Override
        public boolean hasMultipleValues() {
            return false;
        }

        @Override
        public int getSingleValueRow(int rowNum) {
            throw new RuntimeException("This method should not be called for null-only columns");
        }

        @Override
        public IndexedInts getMultiValueRow(int rowNum) {
            throw new RuntimeException("This method should not be called for null-only columns");
        }

        @Override
        @Nullable
        public String lookupName(int id) {
            return this.nullDimensionSelector.lookupName(id);
        }

        @Override
        public int lookupId(String name) {
            return this.nullDimensionSelector.idLookup().lookupId(name);
        }

        @Override
        public int getCardinality() {
            return 1;
        }

        @Override
        public DimensionSelector makeDimensionSelector(ReadableOffset offset, @Nullable ExtractionFn extractionFn) {
            return DimensionSelector.constant(null, extractionFn);
        }

        @Override
        public SingleValueDimensionVectorSelector makeSingleValueDimensionVectorSelector(ReadableVectorOffset vectorOffset) {
            return NilVectorSelector.create(vectorOffset);
        }

        @Override
        public MultiValueDimensionVectorSelector makeMultiValueDimensionVectorSelector(ReadableVectorOffset vectorOffset) {
            throw new UnsupportedOperationException("This method should not be called for null-only columns");
        }

        @Override
        public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
            return NilVectorSelector.create(offset);
        }

        @Override
        public VectorObjectSelector makeVectorObjectSelector(ReadableVectorOffset offset) {
            return NilVectorSelector.create(offset);
        }

        @Override
        public void close() {
        }
    }
}

