/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.ColumnarLongsSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public final class ScalarLongFieldColumnWriter
extends GlobalDictionaryEncodedFieldColumnWriter<Long> {
    private ColumnarLongsSerializer longsSerializer;

    public ScalarLongFieldColumnWriter(String columnName, String fieldName, SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec, DictionaryIdLookup globalDictionaryIdLookup) {
        super(columnName, fieldName, segmentWriteOutMedium, indexSpec, globalDictionaryIdLookup);
    }

    @Override
    int lookupGlobalId(Long value) {
        return this.globalDictionaryIdLookup.lookupLong(value);
    }

    @Override
    void writeValue(@Nullable Long value) throws IOException {
        if (value == null) {
            this.longsSerializer.add(0L);
        } else {
            this.longsSerializer.add(value);
        }
    }

    @Override
    public void openColumnSerializer(SegmentWriteOutMedium medium, int maxId) throws IOException {
        super.openColumnSerializer(medium, maxId);
        this.longsSerializer = CompressionFactory.getLongSerializer(this.fieldName, medium, StringUtils.format("%s.long_column", this.fieldName), ByteOrder.nativeOrder(), this.indexSpec.getLongEncoding(), this.indexSpec.getDimensionCompression(), this.fieldResourceCloser);
        this.longsSerializer.open();
    }

    @Override
    void writeColumnTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeLongAndDoubleColumnLength(channel, Ints.checkedCast((long)this.longsSerializer.getSerializedSize()), 0);
        this.longsSerializer.writeTo(channel, smoosher);
        this.encodedValueSerializer.writeTo(channel, smoosher);
    }

    @Override
    long getSerializedColumnSize() throws IOException {
        return super.getSerializedColumnSize() + this.longsSerializer.getSerializedSize();
    }
}

