/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinMatcher;
import org.apache.druid.segment.join.table.RowBasedIndexBuilder;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.apache.druid.timeline.SegmentId;

public class BroadcastSegmentIndexedTable
implements IndexedTable {
    private static final Logger LOG = new Logger(BroadcastSegmentIndexedTable.class);
    private static final byte CACHE_PREFIX = 1;
    private final QueryableIndexSegment segment;
    private final CursorFactory cursorFactory;
    private final QueryableIndex queryableIndex;
    private final Set<String> keyColumns;
    private final RowSignature rowSignature;
    private final String version;
    private final List<IndexedTable.Index> keyColumnsIndexes;

    public BroadcastSegmentIndexedTable(QueryableIndexSegment theSegment, Set<String> keyColumns, String version) {
        this.keyColumns = keyColumns;
        this.version = version;
        this.segment = (QueryableIndexSegment)Preconditions.checkNotNull((Object)theSegment, (Object)"Segment must not be null");
        this.cursorFactory = (CursorFactory)Preconditions.checkNotNull((Object)this.segment.as(CursorFactory.class), (String)"Segment[%s] must have a cursor factory", (Object)this.segment.getId());
        this.queryableIndex = (QueryableIndex)Preconditions.checkNotNull((Object)this.segment.as(QueryableIndex.class), (String)"Segment[%s] must have a QueryableIndex", (Object)this.segment.getId());
        this.rowSignature = this.cursorFactory.getRowSignature();
        ArrayList<RowBasedIndexBuilder> indexBuilders = new ArrayList<RowBasedIndexBuilder>(this.rowSignature.size());
        ArrayList<String> keyColumnNames = new ArrayList<String>(keyColumns.size());
        for (int i = 0; i < this.rowSignature.size(); ++i) {
            RowBasedIndexBuilder m;
            String columnName2 = this.rowSignature.getColumnName(i);
            if (keyColumns.contains(columnName2)) {
                ColumnType keyType = this.rowSignature.getColumnType(i).orElse(IndexedTableJoinMatcher.DEFAULT_KEY_TYPE);
                m = new RowBasedIndexBuilder(keyType);
                keyColumnNames.add(columnName2);
            } else {
                m = null;
            }
            indexBuilders.add(m);
        }
        try (CursorHolder cursorHolder = this.cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            if (cursor == null) {
                this.keyColumnsIndexes = Collections.emptyList();
                return;
            }
            int rowNumber = 0;
            ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            List selectors = keyColumnNames.stream().map(columnName -> {
                if (columnSelectorFactory.getColumnCapabilities((String)columnName).hasMultipleValues().isMaybeTrue()) {
                    return NilColumnValueSelector.instance();
                }
                return columnSelectorFactory.makeColumnValueSelector((String)columnName);
            }).collect(Collectors.toList());
            while (!cursor.isDone()) {
                for (int keyColumnSelectorIndex = 0; keyColumnSelectorIndex < selectors.size(); ++keyColumnSelectorIndex) {
                    String keyColumnName = (String)keyColumnNames.get(keyColumnSelectorIndex);
                    int columnPosition = this.rowSignature.indexOf(keyColumnName);
                    RowBasedIndexBuilder keyColumnIndexBuilder = (RowBasedIndexBuilder)indexBuilders.get(columnPosition);
                    keyColumnIndexBuilder.add(((BaseObjectColumnValueSelector)selectors.get(keyColumnSelectorIndex)).getObject());
                }
                if (rowNumber % 100000 == 0) {
                    if (rowNumber == 0) {
                        LOG.debug("Indexed first row for table %s", theSegment.getId());
                    } else {
                        LOG.debug("Indexed row %s for table %s", rowNumber, theSegment.getId());
                    }
                }
                ++rowNumber;
                cursor.advance();
            }
            this.keyColumnsIndexes = indexBuilders.stream().map(builder -> builder != null ? builder.build() : null).collect(Collectors.toList());
            LOG.info("Created BroadcastSegmentIndexedTable with %s rows.", rowNumber);
        }
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public Set<String> keyColumns() {
        return this.keyColumns;
    }

    @Override
    public RowSignature rowSignature() {
        return this.rowSignature;
    }

    @Override
    public int numRows() {
        return this.queryableIndex.getNumRows();
    }

    @Override
    public IndexedTable.Index columnIndex(int column) {
        return RowBasedIndexedTable.getKeyColumnIndex(column, this.keyColumnsIndexes);
    }

    @Override
    public IndexedTable.Reader columnReader(int column) {
        if (!this.rowSignature.contains(column)) {
            throw new IAE("Column[%d] is not a valid column for segment[%s]", column, this.segment.getId());
        }
        final SimpleAscendingOffset offset = new SimpleAscendingOffset(this.queryableIndex.getNumRows());
        final BaseColumn baseColumn = this.queryableIndex.getColumnHolder(this.rowSignature.getColumnName(column)).getColumn();
        final ColumnValueSelector<?> selector = baseColumn.makeColumnValueSelector(offset);
        return new IndexedTable.Reader(){

            @Override
            @Nullable
            public Object read(int row) {
                offset.setCurrentOffset(row);
                return selector.getObject();
            }

            @Override
            public void close() throws IOException {
                baseColumn.close();
            }
        };
    }

    @Override
    @Nullable
    public ColumnSelectorFactory makeColumnSelectorFactory(ReadableOffset offset, Closer closer) {
        return new QueryableIndexColumnSelectorFactory(VirtualColumns.EMPTY, Cursors.getTimeOrdering(this.queryableIndex.getOrdering()), offset, new ColumnCache(this.queryableIndex, closer));
    }

    @Override
    public byte[] computeCacheKey() {
        SegmentId segmentId = this.segment.getId();
        CacheKeyBuilder keyBuilder = new CacheKeyBuilder(1);
        return keyBuilder.appendLong(segmentId.getInterval().getStartMillis()).appendLong(segmentId.getInterval().getEndMillis()).appendString(segmentId.getVersion()).appendString(segmentId.getDataSource()).appendInt(segmentId.getPartitionNum()).build();
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Optional<Closeable> acquireReference() {
        return Optional.of(() -> {});
    }
}

