/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.ExpressionTypeConversion;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.NvlDoubleVectorProcessor;
import org.apache.druid.math.expr.vector.NvlFunctionVectorProcessor;
import org.apache.druid.math.expr.vector.NvlLongVectorProcessor;
import org.apache.druid.math.expr.vector.NvlVectorObjectProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;

public class VectorConditionalProcessors {
    public static <T> ExprVectorProcessor<T> nvl(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        ExpressionType rightType;
        ExpressionType leftType = left.getOutputType(inspector);
        ExpressionType outputType = ExpressionTypeConversion.leastRestrictiveType(leftType, rightType = right.getOutputType(inspector));
        if (outputType == null) {
            return VectorProcessors.constant((Long)null, inspector.getMaxVectorSize());
        }
        NvlFunctionVectorProcessor processor = outputType.is(ExprType.LONG) ? new NvlLongVectorProcessor(left.asVectorProcessor(inspector), right.asVectorProcessor(inspector)) : (outputType.is(ExprType.DOUBLE) ? new NvlDoubleVectorProcessor(CastToTypeVectorProcessor.cast(left.asVectorProcessor(inspector), ExpressionType.DOUBLE), CastToTypeVectorProcessor.cast(right.asVectorProcessor(inspector), ExpressionType.DOUBLE)) : new NvlVectorObjectProcessor(outputType, CastToTypeVectorProcessor.cast(left.asVectorProcessor(inspector), outputType), CastToTypeVectorProcessor.cast(right.asVectorProcessor(inspector), outputType)));
        return processor;
    }
}

