/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment.columnar;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.query.OrderBy;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.joda.time.Interval;

public class FrameQueryableIndex
implements QueryableIndex {
    private final Frame frame;
    private final RowSignature signature;
    private final List<FrameColumnReader> columnReaders;

    public FrameQueryableIndex(Frame frame, RowSignature signature, List<FrameColumnReader> columnReaders) {
        this.frame = frame.ensureColumnar();
        this.signature = signature;
        this.columnReaders = columnReaders;
    }

    @Override
    public int getNumRows() {
        return this.frame.numRows();
    }

    @Override
    public List<String> getColumnNames() {
        return this.signature.getColumnNames();
    }

    @Override
    @Nullable
    public ColumnHolder getColumnHolder(String columnName) {
        int columnIndex = this.signature.indexOf(columnName);
        if (columnIndex < 0) {
            return null;
        }
        return this.columnReaders.get(columnIndex).readColumn(this.frame);
    }

    @Override
    public Interval getDataInterval() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>(this.signature.getColumnNames());
    }

    @Override
    public List<OrderBy> getOrdering() {
        return Collections.emptyList();
    }

    @Override
    public BitmapFactory getBitmapFactoryForDimensions() {
        return new RoaringBitmapFactory();
    }

    @Override
    @Nullable
    public Metadata getMetadata() {
        return null;
    }

    @Override
    public Map<String, DimensionHandler> getDimensionHandlers() {
        return Collections.emptyMap();
    }

    @Override
    public void close() {
    }
}

