/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.utils.CollectionUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="aggregate")
public class AggregateProjectionSpec {
    public static final String TYPE_NAME = "aggregate";
    private final String name;
    private final List<DimensionSchema> groupingColumns;
    private final VirtualColumns virtualColumns;
    private final AggregatorFactory[] aggregators;
    private final List<OrderBy> ordering;
    @Nullable
    private final String timeColumnName;

    @JsonCreator
    public AggregateProjectionSpec(@JsonProperty(value="name") String name, @JsonProperty(value="virtualColumns") @Nullable VirtualColumns virtualColumns, @JsonProperty(value="groupingColumns") @Nullable List<DimensionSchema> groupingColumns, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators) {
        if (name == null || name.isEmpty()) {
            throw InvalidInput.exception("projection name cannot be null or empty", new Object[0]);
        }
        this.name = name;
        if (CollectionUtils.isNullOrEmpty(groupingColumns) && (aggregators == null || aggregators.length == 0)) {
            throw InvalidInput.exception("projection[%s] groupingColumns and aggregators must not both be null or empty", name);
        }
        this.groupingColumns = groupingColumns == null ? Collections.emptyList() : groupingColumns;
        this.virtualColumns = virtualColumns == null ? VirtualColumns.EMPTY : virtualColumns;
        ProjectionOrdering ordering = AggregateProjectionSpec.computeOrdering(this.virtualColumns, this.groupingColumns);
        this.ordering = ordering.ordering;
        this.timeColumnName = ordering.timeColumnName;
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public VirtualColumns getVirtualColumns() {
        return this.virtualColumns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<DimensionSchema> getGroupingColumns() {
        return this.groupingColumns;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    @JsonIgnore
    public AggregateProjectionMetadata.Schema toMetadataSchema() {
        return new AggregateProjectionMetadata.Schema(this.name, this.timeColumnName, this.virtualColumns, this.groupingColumns.stream().map(DimensionSchema::getName).collect(Collectors.toList()), this.aggregators, this.ordering);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateProjectionSpec that = (AggregateProjectionSpec)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.groupingColumns, that.groupingColumns) && Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.deepEquals(this.aggregators, that.aggregators) && Objects.equals(this.ordering, that.ordering);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.groupingColumns, this.virtualColumns, Arrays.hashCode(this.aggregators), this.ordering);
    }

    public String toString() {
        return "AggregateProjectionSpec{name='" + this.name + "', groupingColumns=" + String.valueOf(this.groupingColumns) + ", virtualColumns=" + String.valueOf(this.virtualColumns) + ", aggregators=" + Arrays.toString(this.aggregators) + ", ordering=" + String.valueOf(this.ordering) + "}";
    }

    private static ProjectionOrdering computeOrdering(VirtualColumns virtualColumns, List<DimensionSchema> groupingColumns) {
        if (groupingColumns.isEmpty()) {
            return new ProjectionOrdering(Cursors.ascendingTimeOrder(), null);
        }
        ArrayList ordering = Lists.newArrayListWithCapacity((int)groupingColumns.size());
        String timeColumnName = null;
        Granularity granularity = null;
        for (DimensionSchema dimension : groupingColumns) {
            ordering.add(OrderBy.ascending(dimension.getName()));
            if ("__time".equals(dimension.getName())) {
                timeColumnName = dimension.getName();
                granularity = Granularities.NONE;
                continue;
            }
            VirtualColumn vc = virtualColumns.getVirtualColumn(dimension.getName());
            Granularity maybeGranularity = Granularities.fromVirtualColumn(vc);
            if (granularity == null && maybeGranularity != null) {
                granularity = maybeGranularity;
                timeColumnName = dimension.getName();
                continue;
            }
            if (granularity == null || maybeGranularity == null || !maybeGranularity.isFinerThan(granularity)) continue;
            granularity = maybeGranularity;
            timeColumnName = dimension.getName();
        }
        return new ProjectionOrdering(ordering, timeColumnName);
    }

    private static final class ProjectionOrdering {
        private final List<OrderBy> ordering;
        @Nullable
        private final String timeColumnName;

        private ProjectionOrdering(List<OrderBy> ordering, @Nullable String timeColumnName) {
            this.ordering = ordering;
            this.timeColumnName = timeColumnName;
        }
    }
}

