/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.segment.vector.VectorValueSelector;

public class ExpressionVectorValueSelector
implements VectorValueSelector {
    final Expr.VectorInputBinding bindings;
    final ExprVectorProcessor<?> processor;
    final float[] floats;

    public ExpressionVectorValueSelector(ExprVectorProcessor<?> processor, Expr.VectorInputBinding bindings) {
        this.processor = (ExprVectorProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
        this.bindings = (Expr.VectorInputBinding)Preconditions.checkNotNull((Object)bindings, (Object)"bindings");
        this.floats = new float[bindings.getMaxVectorSize()];
    }

    @Override
    public long[] getLongVector() {
        return this.processor.evalVector(this.bindings).getLongVector();
    }

    @Override
    public float[] getFloatVector() {
        double[] doubles = this.processor.evalVector(this.bindings).getDoubleVector();
        for (int i = 0; i < this.bindings.getCurrentVectorSize(); ++i) {
            this.floats[i] = (float)doubles[i];
        }
        return this.floats;
    }

    @Override
    public double[] getDoubleVector() {
        return this.processor.evalVector(this.bindings).getDoubleVector();
    }

    @Override
    @Nullable
    public boolean[] getNullVector() {
        return this.processor.evalVector(this.bindings).getNullVector();
    }

    @Override
    public int getMaxVectorSize() {
        return this.bindings.getMaxVectorSize();
    }

    @Override
    public int getCurrentVectorSize() {
        return this.bindings.getCurrentVectorSize();
    }
}

