/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.query.expression.ExprUtils;
import org.apache.druid.query.expression.IPv4AddressExprUtils;

public class IPv4AddressMatchExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "ipv4_match";
    private static final int ARG_SUBNET = 1;

    public String name() {
        return FN_NAME;
    }

    public Expr apply(List<Expr> args) {
        if (args.size() != 2) {
            throw new IAE(ExprUtils.createErrMsg(this.name(), "must have 2 arguments"), new Object[0]);
        }
        SubnetUtils.SubnetInfo subnetInfo = this.getSubnetInfo(args);
        Expr arg = args.get(0);
        class IPv4AddressMatchExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            private final SubnetUtils.SubnetInfo subnetInfo;
            final /* synthetic */ List val$args;

            IPv4AddressMatchExpr(Expr arg, SubnetUtils.SubnetInfo subnetInfo) {
                this.val$args = list;
                super(IPv4AddressMatchExprMacro.FN_NAME, arg);
                this.subnetInfo = subnetInfo;
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                boolean match;
                ExprEval eval = this.arg.eval(bindings);
                switch (eval.type()) {
                    case STRING: {
                        match = this.isStringMatch(eval.asString());
                        break;
                    }
                    case LONG: {
                        match = !eval.isNumericNull() && this.isLongMatch(eval.asLong());
                        break;
                    }
                    default: {
                        match = false;
                    }
                }
                return ExprEval.ofLongBoolean((boolean)match);
            }

            private boolean isStringMatch(String stringValue) {
                return IPv4AddressExprUtils.isValidAddress(stringValue) && this.subnetInfo.isInRange(stringValue);
            }

            private boolean isLongMatch(long longValue) {
                return !IPv4AddressExprUtils.overflowsUnsignedInt(longValue) && this.subnetInfo.isInRange((int)longValue);
            }

            public Expr visit(Expr.Shuttle shuttle) {
                Expr newArg = this.arg.visit(shuttle);
                return shuttle.visit((Expr)new IPv4AddressMatchExpr(newArg, this.subnetInfo));
            }

            @Nullable
            public ExprType getOutputType(Expr.InputBindingTypes inputTypes) {
                return ExprType.LONG;
            }

            public String stringify() {
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{IPv4AddressMatchExprMacro.FN_NAME, this.arg.stringify(), ((Expr)this.val$args.get(1)).stringify()});
            }
        }
        return new IPv4AddressMatchExpr(arg, subnetInfo);
    }

    private SubnetUtils.SubnetInfo getSubnetInfo(List<Expr> args) {
        SubnetUtils subnetUtils;
        String subnetArgName = "subnet";
        Expr arg = args.get(1);
        ExprUtils.checkLiteralArgument(this.name(), arg, subnetArgName);
        String subnet = (String)arg.getLiteralValue();
        try {
            subnetUtils = new SubnetUtils(subnet);
        }
        catch (IllegalArgumentException e) {
            throw new IAE((Throwable)e, ExprUtils.createErrMsg(this.name(), subnetArgName + " arg has an invalid format: " + subnet), new Object[0]);
        }
        subnetUtils.setInclusiveHostCount(true);
        return subnetUtils.getInfo();
    }
}

