/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import javax.annotation.Nullable;
import org.apache.druid.query.QueryException;

public class QueryUnsupportedException
extends QueryException {
    private static final String ERROR_CLASS = QueryUnsupportedException.class.getName();
    public static final String ERROR_CODE = "Unsupported query";
    public static final int STATUS_CODE = 400;

    @JsonCreator
    public QueryUnsupportedException(@JsonProperty(value="error") @Nullable String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") @Nullable String errorClass, @JsonProperty(value="host") @Nullable String host) {
        super(errorCode, errorMessage, errorClass, host);
    }

    public QueryUnsupportedException(String errorMessage) {
        super(ERROR_CODE, errorMessage, ERROR_CLASS, QueryUnsupportedException.resolveHostname());
    }

    private static String resolveHostname() {
        String host;
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            host = null;
        }
        return host;
    }
}

