/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import org.apache.druid.testing.utils.SuiteListener;
import org.testng.DataProviderHolder;
import org.testng.IClassListener;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ITestRunnerFactory;
import org.testng.TestNG;
import org.testng.TestRunner;
import org.testng.internal.IConfiguration;
import org.testng.internal.Systematiser;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlTest;

public class DruidTestRunnerFactory
implements ITestRunnerFactory {
    private static final SuiteListener SUITE_LISTENER = new SuiteListener();

    public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> methodListeners, List<IClassListener> classListeners) {
        IConfiguration configuration = TestNG.getDefault().getConfiguration();
        String outputDirectory = suite.getOutputDirectory();
        IAnnotationFinder annotationFinder = configuration.getAnnotationFinder();
        Boolean skipFailedInvocationCounts = suite.getXmlSuite().skipFailedInvocationCounts();
        return new DruidTestRunner(configuration, suite, test, outputDirectory, annotationFinder, skipFailedInvocationCounts, methodListeners, classListeners);
    }

    private static class DruidTestRunner
    extends TestRunner {
        DruidTestRunner(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> methodListeners, List<IClassListener> classListeners) {
            super(configuration, suite, test, outputDirectory, finder, skipFailedInvocationCounts, methodListeners, classListeners, Systematiser.getComparator(), new DataProviderHolder());
        }

        public void run() {
            try {
                if (!"IntegrationTestSuite".equals(this.getSuite().getName())) {
                    SUITE_LISTENER.onStart(this.getSuite());
                }
                this.runTests();
            }
            finally {
                if (!"IntegrationTestSuite".equals(this.getSuite().getName())) {
                    SUITE_LISTENER.onFinish(this.getSuite());
                }
            }
        }

        private void runTests() {
            super.run();
        }
    }
}

