/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.AdminClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.Assert;

public class SecurityClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String coordinator;
    private final StatusResponseHandler responseHandler;

    @Inject
    SecurityClient(ObjectMapper jsonMapper, @AdminClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.coordinator = config.getCoordinatorUrl();
        this.responseHandler = StatusResponseHandler.getInstance();
    }

    public void createAuthenticationUser(String username) throws IOException {
        Request request = new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%s/users/%s", (Object[])new Object[]{this.getAuthenticatorURL(), StringUtils.urlEncode((String)username)})));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    public void deleteAuthenticationUser(String username) throws IOException {
        Request request = new Request(HttpMethod.DELETE, new URL(StringUtils.format((String)"%s/users/%s", (Object[])new Object[]{this.getAuthenticatorURL(), StringUtils.urlEncode((String)username)})));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    public void setUserPassword(String username, String password) throws IOException {
        Request request = new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%s/users/%s/credentials", (Object[])new Object[]{this.getAuthenticatorURL(), StringUtils.urlEncode((String)username)})));
        request.setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)ImmutableMap.of((Object)"password", (Object)password)));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    public void createAuthorizerUser(String username) throws IOException {
        Request request = new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%s/users/%s", (Object[])new Object[]{this.getAuthorizerURL(), StringUtils.urlEncode((String)username)})));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    public void deleteAuthorizerUser(String username) throws IOException {
        Request request = new Request(HttpMethod.DELETE, new URL(StringUtils.format((String)"%s/users/%s", (Object[])new Object[]{this.getAuthorizerURL(), StringUtils.urlEncode((String)username)})));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    public void createAuthorizerRole(String role) throws IOException {
        Request request = new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%s/roles/%s", (Object[])new Object[]{this.getAuthorizerURL(), StringUtils.urlEncode((String)role)})));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    public void deleteAuthorizerRole(String role) throws IOException {
        Request request = new Request(HttpMethod.DELETE, new URL(StringUtils.format((String)"%s/roles/%s", (Object[])new Object[]{this.getAuthorizerURL(), StringUtils.urlEncode((String)role)})));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    public void assignUserToRole(String user, String role) throws IOException {
        Request request = new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%s/users/%s/roles/%s", (Object[])new Object[]{this.getAuthorizerURL(), StringUtils.urlEncode((String)user), StringUtils.urlEncode((String)role)})));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    public void setPermissionsToRole(String role, List<ResourceAction> permissions) throws IOException {
        Request request = new Request(HttpMethod.POST, new URL(StringUtils.format((String)"%s/roles/%s/permissions/", (Object[])new Object[]{this.getAuthorizerURL(), StringUtils.urlEncode((String)role)}))).setContent("application/json", this.jsonMapper.writeValueAsBytes(permissions));
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)this.sendRequest(request).getStatus());
    }

    private StatusResponseHolder sendRequest(Request request) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(request, (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while creating users status [%s] content [%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getAuthenticatorURL() {
        return StringUtils.format((String)"%s/druid-ext/basic-security/authentication/db/basic", (Object[])new Object[]{this.coordinator});
    }

    private String getAuthorizerURL() {
        return StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/basic", (Object[])new Object[]{this.coordinator});
    }
}

